/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.repository;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.java.Bucket;
import com.couchbase.client.java.PersistTo;
import com.couchbase.client.java.ReplicaMode;
import com.couchbase.client.java.ReplicateTo;
import com.couchbase.client.java.document.EntityDocument;
import com.couchbase.client.java.env.CouchbaseEnvironment;
import com.couchbase.client.java.repository.AsyncRepository;
import com.couchbase.client.java.repository.Repository;
import com.couchbase.client.java.util.Blocking;
import java.util.List;
import java.util.concurrent.TimeUnit;

@InterfaceAudience.Public
@InterfaceStability.Experimental
public class CouchbaseRepository
implements Repository {
    private static final TimeUnit TIMEOUT_UNIT = TimeUnit.MILLISECONDS;
    private final AsyncRepository asyncRepository;
    private final long timeout;

    public CouchbaseRepository(Bucket bucket, CouchbaseEnvironment environment) {
        this.timeout = environment.kvTimeout();
        this.asyncRepository = bucket.async().repository().toBlocking().single();
    }

    @Override
    public AsyncRepository async() {
        return this.asyncRepository;
    }

    @Override
    public <T> EntityDocument<T> get(String id, Class<T> entityClass) {
        return this.get(id, entityClass, this.timeout, TIMEOUT_UNIT);
    }

    @Override
    public <T> EntityDocument<T> get(String id, Class<T> entityClass, long timeout, TimeUnit timeUnit) {
        return Blocking.blockForSingle(this.asyncRepository.get(id, entityClass), timeout, timeUnit);
    }

    @Override
    public <T> EntityDocument<T> upsert(EntityDocument<T> document) {
        return this.upsert(document, this.timeout, TIMEOUT_UNIT);
    }

    @Override
    public <T> EntityDocument<T> upsert(EntityDocument<T> document, long timeout, TimeUnit timeUnit) {
        return Blocking.blockForSingle(this.asyncRepository.upsert(document), timeout, timeUnit);
    }

    @Override
    public <T> List<EntityDocument<T>> getFromReplica(String id, ReplicaMode type, Class<T> entityClass) {
        return this.getFromReplica(id, type, entityClass, this.timeout, TIMEOUT_UNIT);
    }

    @Override
    public <T> List<EntityDocument<T>> getFromReplica(String id, ReplicaMode type, Class<T> entityClass, long timeout, TimeUnit timeUnit) {
        return Blocking.blockForSingle(this.asyncRepository.getFromReplica(id, type, entityClass).toList(), timeout, timeUnit);
    }

    @Override
    public <T> EntityDocument<T> getAndLock(String id, int lockTime, Class<T> entityClass) {
        return this.getAndLock(id, lockTime, entityClass, this.timeout, TIMEOUT_UNIT);
    }

    @Override
    public <T> EntityDocument<T> getAndLock(String id, int lockTime, Class<T> entityClass, long timeout, TimeUnit timeUnit) {
        return Blocking.blockForSingle(this.asyncRepository.getAndLock(id, lockTime, entityClass), timeout, timeUnit);
    }

    @Override
    public <T> EntityDocument<T> getAndTouch(String id, int expiry, Class<T> entityClass) {
        return this.getAndTouch(id, expiry, entityClass, this.timeout, TIMEOUT_UNIT);
    }

    @Override
    public <T> EntityDocument<T> getAndTouch(String id, int expiry, Class<T> entityClass, long timeout, TimeUnit timeUnit) {
        return Blocking.blockForSingle(this.asyncRepository.getAndTouch(id, expiry, entityClass), timeout, timeUnit);
    }

    @Override
    public boolean exists(String id) {
        return this.exists(id, this.timeout, TIMEOUT_UNIT);
    }

    @Override
    public boolean exists(String id, long timeout, TimeUnit timeUnit) {
        return Blocking.blockForSingle(this.asyncRepository.exists(id), timeout, timeUnit);
    }

    @Override
    public <T> boolean exists(EntityDocument<T> document) {
        return this.exists(document, this.timeout, TIMEOUT_UNIT);
    }

    @Override
    public <T> boolean exists(EntityDocument<T> document, long timeout, TimeUnit timeUnit) {
        return Blocking.blockForSingle(this.asyncRepository.exists(document), timeout, timeUnit);
    }

    @Override
    public <T> EntityDocument<T> upsert(EntityDocument<T> document, PersistTo persistTo) {
        return this.upsert(document, persistTo, this.timeout, TIMEOUT_UNIT);
    }

    @Override
    public <T> EntityDocument<T> upsert(EntityDocument<T> document, PersistTo persistTo, long timeout, TimeUnit timeUnit) {
        return this.upsert(document, persistTo, ReplicateTo.NONE, timeout, timeUnit);
    }

    @Override
    public <T> EntityDocument<T> upsert(EntityDocument<T> document, ReplicateTo replicateTo) {
        return this.upsert(document, replicateTo, this.timeout, TIMEOUT_UNIT);
    }

    @Override
    public <T> EntityDocument<T> upsert(EntityDocument<T> document, ReplicateTo replicateTo, long timeout, TimeUnit timeUnit) {
        return this.upsert(document, PersistTo.NONE, replicateTo, timeout, timeUnit);
    }

    @Override
    public <T> EntityDocument<T> upsert(EntityDocument<T> document, PersistTo persistTo, ReplicateTo replicateTo) {
        return this.upsert(document, persistTo, replicateTo, this.timeout, TIMEOUT_UNIT);
    }

    @Override
    public <T> EntityDocument<T> upsert(EntityDocument<T> document, PersistTo persistTo, ReplicateTo replicateTo, long timeout, TimeUnit timeUnit) {
        return Blocking.blockForSingle(this.asyncRepository.upsert(document, persistTo, replicateTo), timeout, timeUnit);
    }

    @Override
    public <T> EntityDocument<T> insert(EntityDocument<T> document, PersistTo persistTo) {
        return this.insert(document, persistTo, this.timeout, TIMEOUT_UNIT);
    }

    @Override
    public <T> EntityDocument<T> insert(EntityDocument<T> document, PersistTo persistTo, long timeout, TimeUnit timeUnit) {
        return this.insert(document, persistTo, ReplicateTo.NONE, timeout, timeUnit);
    }

    @Override
    public <T> EntityDocument<T> insert(EntityDocument<T> document, ReplicateTo replicateTo) {
        return this.insert(document, replicateTo, this.timeout, TIMEOUT_UNIT);
    }

    @Override
    public <T> EntityDocument<T> insert(EntityDocument<T> document, ReplicateTo replicateTo, long timeout, TimeUnit timeUnit) {
        return this.insert(document, PersistTo.NONE, replicateTo, timeout, timeUnit);
    }

    @Override
    public <T> EntityDocument<T> insert(EntityDocument<T> document, PersistTo persistTo, ReplicateTo replicateTo) {
        return this.insert(document, persistTo, replicateTo, this.timeout, TIMEOUT_UNIT);
    }

    @Override
    public <T> EntityDocument<T> insert(EntityDocument<T> document, PersistTo persistTo, ReplicateTo replicateTo, long timeout, TimeUnit timeUnit) {
        return Blocking.blockForSingle(this.asyncRepository.insert(document, persistTo, replicateTo), timeout, timeUnit);
    }

    @Override
    public <T> EntityDocument<T> insert(EntityDocument<T> document) {
        return this.insert(document, this.timeout, TIMEOUT_UNIT);
    }

    @Override
    public <T> EntityDocument<T> insert(EntityDocument<T> document, long timeout, TimeUnit timeUnit) {
        return this.insert(document, PersistTo.NONE, ReplicateTo.NONE, timeout, timeUnit);
    }

    @Override
    public <T> EntityDocument<T> replace(EntityDocument<T> document) {
        return this.replace(document, this.timeout, TIMEOUT_UNIT);
    }

    @Override
    public <T> EntityDocument<T> replace(EntityDocument<T> document, long timeout, TimeUnit timeUnit) {
        return this.replace(document, PersistTo.NONE, ReplicateTo.NONE, timeout, timeUnit);
    }

    @Override
    public <T> EntityDocument<T> replace(EntityDocument<T> document, PersistTo persistTo) {
        return this.replace(document, persistTo, this.timeout, TIMEOUT_UNIT);
    }

    @Override
    public <T> EntityDocument<T> replace(EntityDocument<T> document, PersistTo persistTo, long timeout, TimeUnit timeUnit) {
        return this.replace(document, persistTo, ReplicateTo.NONE, timeout, timeUnit);
    }

    @Override
    public <T> EntityDocument<T> replace(EntityDocument<T> document, ReplicateTo replicateTo) {
        return this.replace(document, replicateTo, this.timeout, TIMEOUT_UNIT);
    }

    @Override
    public <T> EntityDocument<T> replace(EntityDocument<T> document, ReplicateTo replicateTo, long timeout, TimeUnit timeUnit) {
        return this.replace(document, PersistTo.NONE, replicateTo, timeout, timeUnit);
    }

    @Override
    public <T> EntityDocument<T> replace(EntityDocument<T> document, PersistTo persistTo, ReplicateTo replicateTo) {
        return this.replace(document, persistTo, replicateTo, this.timeout, TIMEOUT_UNIT);
    }

    @Override
    public <T> EntityDocument<T> replace(EntityDocument<T> document, PersistTo persistTo, ReplicateTo replicateTo, long timeout, TimeUnit timeUnit) {
        return Blocking.blockForSingle(this.asyncRepository.replace(document, persistTo, replicateTo), timeout, timeUnit);
    }

    @Override
    public <T> EntityDocument<T> remove(EntityDocument<T> document) {
        return this.remove(document, this.timeout, TIMEOUT_UNIT);
    }

    @Override
    public <T> EntityDocument<T> remove(EntityDocument<T> document, long timeout, TimeUnit timeUnit) {
        return this.remove(document, PersistTo.NONE, ReplicateTo.NONE, timeout, timeUnit);
    }

    @Override
    public <T> EntityDocument<T> remove(EntityDocument<T> document, PersistTo persistTo) {
        return this.remove(document, persistTo, ReplicateTo.NONE, this.timeout, TIMEOUT_UNIT);
    }

    @Override
    public <T> EntityDocument<T> remove(EntityDocument<T> document, PersistTo persistTo, long timeout, TimeUnit timeUnit) {
        return this.remove(document, persistTo, ReplicateTo.NONE, timeout, timeUnit);
    }

    @Override
    public <T> EntityDocument<T> remove(EntityDocument<T> document, ReplicateTo replicateTo) {
        return this.remove(document, PersistTo.NONE, replicateTo, this.timeout, TIMEOUT_UNIT);
    }

    @Override
    public <T> EntityDocument<T> remove(EntityDocument<T> document, ReplicateTo replicateTo, long timeout, TimeUnit timeUnit) {
        return this.remove(document, PersistTo.NONE, replicateTo, timeout, timeUnit);
    }

    @Override
    public <T> EntityDocument<T> remove(EntityDocument<T> document, PersistTo persistTo, ReplicateTo replicateTo) {
        return this.remove(document, persistTo, replicateTo, this.timeout, TIMEOUT_UNIT);
    }

    @Override
    public <T> EntityDocument<T> remove(EntityDocument<T> document, PersistTo persistTo, ReplicateTo replicateTo, long timeout, TimeUnit timeUnit) {
        return Blocking.blockForSingle(this.asyncRepository.remove(document, persistTo, replicateTo), timeout, timeUnit);
    }

    @Override
    public <T> EntityDocument<T> remove(String id, Class<T> entityClass) {
        return this.remove(id, entityClass, this.timeout, TIMEOUT_UNIT);
    }

    @Override
    public <T> EntityDocument<T> remove(String id, Class<T> entityClass, long timeout, TimeUnit timeUnit) {
        return this.remove(id, PersistTo.NONE, ReplicateTo.NONE, entityClass, timeout, timeUnit);
    }

    @Override
    public <T> EntityDocument<T> remove(String id, PersistTo persistTo, Class<T> entityClass) {
        return this.remove(id, persistTo, ReplicateTo.NONE, entityClass, this.timeout, TIMEOUT_UNIT);
    }

    @Override
    public <T> EntityDocument<T> remove(String id, PersistTo persistTo, Class<T> entityClass, long timeout, TimeUnit timeUnit) {
        return this.remove(id, persistTo, ReplicateTo.NONE, entityClass, timeout, timeUnit);
    }

    @Override
    public <T> EntityDocument<T> remove(String id, ReplicateTo replicateTo, Class<T> entityClass) {
        return this.remove(id, PersistTo.NONE, replicateTo, entityClass, this.timeout, TIMEOUT_UNIT);
    }

    @Override
    public <T> EntityDocument<T> remove(String id, ReplicateTo replicateTo, Class<T> entityClass, long timeout, TimeUnit timeUnit) {
        return this.remove(id, PersistTo.NONE, replicateTo, entityClass, timeout, timeUnit);
    }

    @Override
    public <T> EntityDocument<T> remove(String id, PersistTo persistTo, ReplicateTo replicateTo, Class<T> entityClass) {
        return this.remove(id, persistTo, replicateTo, entityClass, this.timeout, TIMEOUT_UNIT);
    }

    @Override
    public <T> EntityDocument<T> remove(String id, PersistTo persistTo, ReplicateTo replicateTo, Class<T> entityClass, long timeout, TimeUnit timeUnit) {
        return Blocking.blockForSingle(this.asyncRepository.remove(id, persistTo, replicateTo, entityClass), timeout, timeUnit);
    }
}

