/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.expression.functions;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.expression.MalformedExpressionException;
import org.gcube.data.analysis.tabulardata.expression.NotEvaluableDataTypeException;
import org.gcube.data.analysis.tabulardata.expression.Operator;
import org.gcube.data.analysis.tabulardata.expression.composite.UnaryExpression;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.datatype.IntegerType;
import org.gcube.data.analysis.tabulardata.model.datatype.NumericType;
import org.gcube.data.analysis.tabulardata.model.datatype.TextType;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Cast
extends UnaryExpression {
    private static final long serialVersionUID = 5205666076797065546L;
    private DataType castToType;

    private Cast() {
    }

    public DataType getCastToType() {
        return this.castToType;
    }

    public void setCastToType(DataType castToType) {
        this.castToType = castToType;
    }

    public Cast(Expression argument, DataType castToType) {
        super(argument);
        this.castToType = castToType;
        if (castToType == null) {
            throw new IllegalArgumentException("Cast to type cannot be null");
        }
    }

    @Override
    public Operator getOperator() {
        return Operator.CAST;
    }

    @Override
    public DataType getReturnedDataType() throws NotEvaluableDataTypeException {
        return this.castToType;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Cast [castToType=");
        builder.append(this.castToType);
        builder.append(", getArgument()=");
        builder.append(this.getArgument());
        builder.append("]");
        return builder.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.castToType == null ? 0 : this.castToType.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Cast other = (Cast)obj;
        return !(this.castToType == null ? other.castToType != null : !this.castToType.equals(other.castToType));
    }

    @Override
    public void validate() throws MalformedExpressionException {
        super.validate();
        try {
            if (!Cast.isCastSupported(this.getArgument().getReturnedDataType(), this.castToType)) {
                throw new MalformedExpressionException(String.format("Cast from %s to %s is not supported", this.getArgument().getReturnedDataType(), this.castToType));
            }
        }
        catch (NotEvaluableDataTypeException notEvaluableDataTypeException) {
            // empty catch block
        }
    }

    public static final boolean isCastSupported(DataType sourceType, DataType targetType) {
        if (targetType instanceof TextType || sourceType instanceof TextType) {
            return true;
        }
        if (sourceType.getClass().equals(targetType.getClass())) {
            return true;
        }
        return sourceType instanceof IntegerType && targetType instanceof NumericType || sourceType instanceof NumericType && targetType instanceof IntegerType;
    }
}

