/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.simulfishgrowthdata.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class UnivariateOutlierDetector {
    final List<IValue> values = new ArrayList<IValue>();
    List<IValue> outliers;
    Double lowerPercentage;
    Double upperPercentage;

    public List<IValue> getOutliers() {
        return this.outliers;
    }

    public List<IValue> getValues() {
        return this.values;
    }

    public UnivariateOutlierDetector cleanFromOutliers() {
        this.values.removeAll(this.outliers);
        return this;
    }

    public UnivariateOutlierDetector addValues(List<IValue> moreValues) {
        this.values.addAll(moreValues);
        return this;
    }

    public UnivariateOutlierDetector cleanOutliers() {
        this.outliers.clear();
        return this;
    }

    public UnivariateOutlierDetector cleanValues() {
        this.values.clear();
        return this;
    }

    public UnivariateOutlierDetector defineLowerPercentage(Double lowerPercentage) {
        this.lowerPercentage = lowerPercentage;
        return this;
    }

    public UnivariateOutlierDetector defineUpperPercentage(Double upperPercentage) {
        this.upperPercentage = upperPercentage;
        return this;
    }

    protected Double quartile(IValue[] v, Double Percent) {
        int n = (int)Math.round((double)v.length * Percent / 100.0);
        return v[n].getValue();
    }

    protected List<IValue> detectOutliers(IValue[] values, Double lowBound, Double upperBound) {
        int vlen = values.length;
        ArrayList<IValue> toRet = new ArrayList<IValue>();
        for (int i = 0; i < vlen; ++i) {
            if (!(values[i].getValue() < lowBound) && !(values[i].getValue() > upperBound)) continue;
            toRet.add(values[i]);
        }
        return toRet;
    }

    public UnivariateOutlierDetector execute() throws Exception {
        if (this.values == null || this.values.isEmpty()) {
            throw new Exception("The data array either is null or does not contain any data.");
        }
        Object[] sortedValues = new IValue[this.values.size()];
        sortedValues = this.values.toArray(sortedValues);
        Arrays.sort(sortedValues);
        System.out.println("sorted " + Arrays.toString(sortedValues));
        Double Q1 = this.quartile((IValue[])sortedValues, this.lowerPercentage);
        Double Q3 = this.quartile((IValue[])sortedValues, this.upperPercentage);
        System.out.println("Q1 = " + Q1 + " , Q3 = " + Q3);
        Double IQR = Q3 - Q1;
        Double lowOutlierBound = Q1 - 3.0 * IQR;
        Double upOutlierBound = Q3 + 3.0 * IQR;
        System.out.println("lowOutlierBound = " + lowOutlierBound + ",upOutlierBound = " + upOutlierBound);
        this.outliers = this.detectOutliers((IValue[])sortedValues, lowOutlierBound, upOutlierBound);
        return this;
    }

    public static void main(String[] args) {
        Double lowerperc = 25.0;
        Double upperperc = 75.0;
        ArrayList<IValue> values_list = new ArrayList<IValue>(Arrays.asList(new SimpleValue(4.0), new SimpleValue(17.0), new SimpleValue(7.0), new SimpleValue(7.5), new SimpleValue(14.0), new SimpleValue(18.0), new SimpleValue(100.5), new SimpleValue(12.0), new SimpleValue(3.0), new SimpleValue(16.0), new SimpleValue(0.0), new SimpleValue(-250.45), new SimpleValue(10.0), new SimpleValue(4.0), new SimpleValue(4.0), new SimpleValue(11.0), new SimpleValue(1000.0), new SimpleValue(-240.0), new SimpleValue(650.0), new SimpleValue(750.0), new SimpleValue(5.4), new SimpleValue(600.75), new SimpleValue(-290.0)));
        try {
            UnivariateOutlierDetector detector = new UnivariateOutlierDetector().addValues(values_list).defineLowerPercentage(lowerperc).defineUpperPercentage(upperperc).execute();
            detector.cleanFromOutliers();
            System.out.println("outliers:");
            List<IValue> outliers = detector.getOutliers();
            for (int i = 0; i < outliers.size(); ++i) {
                System.out.print(outliers.get(i) + " ");
            }
            System.out.println();
            List<IValue> values = detector.getValues();
            for (int i = 0; i < values.size(); ++i) {
                System.out.print(values.get(i) + " ");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class SimpleValue
    implements IValue {
        protected Double value;

        public SimpleValue(Double value) {
            this.value = value;
        }

        @Override
        public Double getValue() {
            return this.value;
        }

        public int compare(Object o1, Object o2) {
            if (o2 == null) {
                return 1;
            }
            if (o1 == null) {
                return -1;
            }
            return ((SimpleValue)o1).getValue().compareTo(((SimpleValue)o2).getValue());
        }

        public String toString() {
            return String.valueOf(this.getValue());
        }

        public int compareTo(Object o) {
            return this.compare(this, o);
        }
    }

    public static interface IValue
    extends Comparator,
    Comparable {
        public Double getValue();
    }
}

