/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.simulfishgrowthdata.util;

import java.security.Key;
import java.util.HashMap;
import java.util.Map;
import org.gcube.common.encryption.StringEncrypter;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.simulfishgrowthdata.util.AccessPointer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GCubeUtils {
    private static final Logger logger = LoggerFactory.getLogger(GCubeUtils.class);
    private static final String JDBC_URI = "jdbc:postgresql://%s/%s";
    private static String className = "org.postgresql.Driver";
    private static String dialect = "org.hibernate.dialect.PostgreSQLDialect";
    private static final Map<String, String> prefilledDBCredentials = new HashMap<String, String>();

    public static synchronized Map<String, String> getCredentials(String dbEndpoint, String scope) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace("getCredentials");
        }
        try {
            ScopeProvider.instance.set(scope);
            ServiceEndpoint.AccessPoint result = new AccessPointer(dbEndpoint).getIt();
            HashMap<String, String> toRet = new HashMap<String, String>();
            toRet.put("hibernate.connection.driver_class", className);
            toRet.put("hibernate.dialect", dialect);
            toRet.put("hibernate.connection.url", String.format(JDBC_URI, result.address(), result.name()));
            toRet.put("hibernate.connection.username", result.username());
            toRet.put("hibernate.connection.password", StringEncrypter.getEncrypter().decrypt(result.password(), new Key[0]));
            return toRet;
        }
        catch (Exception e) {
            logger.error("Exception on ic-client test", (Throwable)e);
            throw new Exception("Error while getting database credentials", e);
        }
    }

    public static synchronized void prefillDBCredentials(String host, String dbname, String dbuser, String dbpassPlain) {
        prefilledDBCredentials.clear();
        prefilledDBCredentials.put("hibernate.connection.driver_class", className);
        prefilledDBCredentials.put("hibernate.dialect", dialect);
        prefilledDBCredentials.put("hibernate.connection.url", String.format(JDBC_URI, host, dbname));
        prefilledDBCredentials.put("hibernate.connection.username", dbuser);
        prefilledDBCredentials.put("hibernate.connection.password", dbpassPlain);
    }

    public static synchronized Map<String, String> getPrefilledCredentials() throws Exception {
        if (prefilledDBCredentials.isEmpty()) {
            throw new Exception("Credentials table is empty. You should prefill it first!");
        }
        return prefilledDBCredentials;
    }

    public static synchronized boolean isPrefilledDBCredentials() {
        return !prefilledDBCredentials.isEmpty();
    }
}

