/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.simulfishgrowthdata.util;

import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.simulfishgrowthdata.util.GCubeUtils;
import org.gcube.data.simulfishgrowthdata.util.HibernateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Setup {
    private static final Logger logger = LoggerFactory.getLogger(Setup.class);
    static final String DEF_DB_ENDPOINT_NAME = "SimulFishGrowth";

    public Setup(String scope) {
        this(scope, DEF_DB_ENDPOINT_NAME);
    }

    public Setup(String scope, String dbEndpointName) {
        ScopeProvider.instance.set(scope);
        if (logger.isTraceEnabled()) {
            logger.trace(String.format("configuring Hibernate", new Object[0]));
        }
        HibernateUtil.configGently(dbEndpointName, scope);
        if (logger.isTraceEnabled()) {
            logger.trace(String.format("configuring Hibernate - done", new Object[0]));
        }
    }

    public Setup(String host, String dbname, String user, String pass) {
        GCubeUtils.prefillDBCredentials(host, dbname, user, pass);
    }
}

