/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataaccess.databases.utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import org.gcube.contentmanagement.lexicalmatcher.analysis.core.LexicalEngineConfiguration;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.contentmanagement.lexicalmatcher.utils.FileTools;
import org.gcube.dataaccess.databases.utils.AliasToEntityOrderedMapResultTransformer;
import org.gcube.dataaccess.databases.utils.DatabaseFactory;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.hibernate.MappingException;
import org.hibernate.SQLQuery;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.classic.Session;
import org.hibernate.exception.GenericJDBCException;
import org.hibernate.exception.SQLGrammarException;
import org.hibernate.transform.ResultTransformer;

public class ConnectionManager {
    public static SessionFactory initDBSession(AlgorithmConfiguration config) {
        SessionFactory dbHibConnection = null;
        try {
            if (config != null && config.getConfigPath() != null) {
                String defaultDatabaseFile = config.getConfigPath() + "DestinationDBHibernateDBManager.cfg.xml";
                config.setDatabaseDriver(config.getParam("DatabaseDriver"));
                config.setDatabaseUserName(config.getParam("DatabaseUserName"));
                config.setDatabasePassword(config.getParam("DatabasePassword"));
                config.setDatabaseURL(config.getParam("DatabaseURL"));
                dbHibConnection = DatabaseFactory.initDBConnection(defaultDatabaseFile, (LexicalEngineConfiguration)config);
            }
        }
        catch (Exception e) {
            AnalysisLogger.getLogger().debug((Object)("In ConnectionManager->  ERROR IN DB INITIALIZATION : " + e.getLocalizedMessage()));
        }
        return dbHibConnection;
    }

    public SessionFactory initDBConnection(AlgorithmConfiguration config) {
        SessionFactory dbconnection = ConnectionManager.initDBSession(config);
        return dbconnection;
    }

    public SessionFactory initDBConnection(String configurationFile) throws Exception {
        String xml = FileTools.readXMLDoc((String)configurationFile);
        SessionFactory DBSessionFactory = null;
        Configuration cfg = new Configuration();
        cfg = cfg.configure(DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(xml.getBytes())));
        DBSessionFactory = cfg.buildSessionFactory();
        return DBSessionFactory;
    }

    public AlgorithmConfiguration setconfiguration(String ConfigPath, String DatabaseUserName, String DatabasePassword, String DatabaseDriver, String DatabaseDialect, String DatabaseURL, String DatabaseName) throws IOException {
        AlgorithmConfiguration config = new AlgorithmConfiguration();
        if (DatabaseName.equals("")) {
            throw new MalformedURLException("Invalid Url: the database's name is not present");
        }
        if (!ConfigPath.equals("")) {
            config.setConfigPath(ConfigPath);
        }
        if (!DatabaseUserName.equals("")) {
            config.setParam("DatabaseUserName", DatabaseUserName);
        }
        if (!DatabasePassword.equals("")) {
            config.setParam("DatabasePassword", DatabasePassword);
        }
        if (!DatabaseDriver.equals("")) {
            config.setParam("DatabaseDriver", DatabaseDriver);
        }
        if (!DatabaseDialect.equals("")) {
            config.setParam("DatabaseDialect", DatabaseDialect);
        }
        if (!DatabaseURL.equals("")) {
            config.setParam("DatabaseURL", DatabaseURL);
        }
        return config;
    }

    public List<Object> executeQueryJDBC(String query, Connection conn) throws Exception {
        ArrayList<Object> result = null;
        Statement stmt = conn.createStatement();
        AnalysisLogger.getLogger().debug((Object)("In ConnectionManager-> executing query: " + query));
        ResultSet rs = stmt.executeQuery(query);
        ArrayList<Object> rows = new ArrayList<Object>();
        while (rs.next()) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            int colNum = rs.getMetaData().getColumnCount();
            for (int i = 1; i < colNum + 1; ++i) {
                String columnName = rs.getMetaData().getColumnLabel(i);
                String columnType = rs.getMetaData().getColumnTypeName(i);
                Object columnValue = rs.getObject(i);
                if (columnType.equals("geometry")) {
                    columnValue = rs.getString(i);
                }
                int j = 1;
                String newcolumnName = columnName;
                while (map.get(newcolumnName) != null) {
                    newcolumnName = columnName + "_" + j;
                    ++j;
                }
                map.put(newcolumnName, columnValue);
            }
            rows.add(map);
        }
        result = rows;
        if (result == null || result.size() == 0) {
            AnalysisLogger.getLogger().debug((Object)"ConnectionManager->Error: Result not available");
            throw new Exception("Result not available");
        }
        stmt.close();
        AnalysisLogger.getLogger().debug((Object)("In ConnectionManager-> result's size: " + result.size()));
        return result;
    }

    public List<Object> executeQuery(String query, SessionFactory DBSessionFactory) throws Exception {
        List obj = null;
        Session ss = null;
        try {
            ss = DBSessionFactory.getCurrentSession();
            ss.beginTransaction();
            SQLQuery qr = null;
            String keyword = "show create table";
            String regex = ".*\\b" + keyword.replaceAll(" +", "[ ]\\+") + "\\b.*";
            if (!query.toLowerCase().contains("explain") && !query.toLowerCase().matches(regex)) {
                if ((query = query.trim()).endsWith(";")) {
                    int endIndex = query.indexOf(";");
                    query = query.substring(0, endIndex);
                }
                query = "select * from (" + query + ") as query";
            }
            AnalysisLogger.getLogger().debug((Object)("In ConnectionManager-> executing query: " + query));
            qr = ss.createSQLQuery(query);
            qr.setResultTransformer((ResultTransformer)AliasToEntityOrderedMapResultTransformer.INSTANCE);
            List result = qr.list();
            AnalysisLogger.getLogger().debug((Object)("In ConnectionManager-> result's size: " + result.size()));
            ss.getTransaction().commit();
            if (result == null || result.size() == 0) {
                AnalysisLogger.getLogger().debug((Object)"ConnectionManager->Error: Result not available");
                throw new Exception("Result not available");
            }
            obj = result;
        }
        catch (Exception e) {
            e.printStackTrace();
            if (e instanceof MappingException) {
                AnalysisLogger.getLogger().debug((Object)("In ConnectionManager-> " + e.getLocalizedMessage()));
                throw new Exception(e.getLocalizedMessage());
            }
            if (e instanceof SQLGrammarException) {
                String cause = "";
                if (e.getCause() != null) {
                    cause = e.getCause().getLocalizedMessage();
                }
                AnalysisLogger.getLogger().debug((Object)("In ConnectionManager-> " + e.getLocalizedMessage() + "." + cause));
                throw new Exception(e.getLocalizedMessage() + "." + cause);
            }
            if (e instanceof GenericJDBCException) {
                AnalysisLogger.getLogger().debug((Object)("In ConnectionManager-> " + e.getLocalizedMessage()));
                throw new Exception(e.getLocalizedMessage());
            }
            throw e;
        }
        return obj;
    }
}

