/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.algorithm.descriptor;

import com.google.common.base.Preconditions;

public abstract class Descriptor {
    private final String identifier;
    private final String title;
    private final String abstrakt;

    Descriptor(Builder<? extends Builder<?>> builder) {
        this.identifier = ((Builder)builder).identifier;
        this.title = ((Builder)builder).title;
        this.abstrakt = ((Builder)builder).abstrakt;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public boolean hasTitle() {
        return this.title != null && this.title.length() > 0;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean hasAbstract() {
        return this.abstrakt != null && this.abstrakt.length() > 0;
    }

    public String getAbstract() {
        return this.abstrakt;
    }

    public static abstract class Builder<B extends Builder<B>> {
        private final String identifier;
        private String title;
        private String abstrakt;

        public Builder(String identifier) {
            Preconditions.checkArgument((identifier != null && !identifier.isEmpty() ? 1 : 0) != 0, (Object)"identifier may not be null or an empty String");
            this.identifier = identifier;
        }

        public B title(String title) {
            this.title = title;
            return this.self();
        }

        public B abstrakt(String abstrakt) {
            this.abstrakt = abstrakt;
            return this.self();
        }

        protected abstract B self();
    }
}

