/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.server;

import java.lang.reflect.Constructor;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import net.opengis.ows.x11.DomainMetadataType;
import net.opengis.wps.x100.CRSsType;
import net.opengis.wps.x100.ComplexDataCombinationType;
import net.opengis.wps.x100.ComplexDataCombinationsType;
import net.opengis.wps.x100.ComplexDataDescriptionType;
import net.opengis.wps.x100.InputDescriptionType;
import net.opengis.wps.x100.LiteralInputType;
import net.opengis.wps.x100.LiteralOutputType;
import net.opengis.wps.x100.OutputDescriptionType;
import net.opengis.wps.x100.ProcessDescriptionType;
import net.opengis.wps.x100.ProcessDescriptionsDocument;
import net.opengis.wps.x100.SupportedCRSsType;
import net.opengis.wps.x100.SupportedComplexDataInputType;
import net.opengis.wps.x100.SupportedComplexDataType;
import org.n52.wps.FormatDocument;
import org.n52.wps.io.GeneratorFactory;
import org.n52.wps.io.IGenerator;
import org.n52.wps.io.IParser;
import org.n52.wps.io.ParserFactory;
import org.n52.wps.io.data.IBBOXData;
import org.n52.wps.io.data.IComplexData;
import org.n52.wps.io.data.ILiteralData;
import org.n52.wps.server.AbstractAlgorithm;
import org.n52.wps.server.observerpattern.IObserver;
import org.n52.wps.server.observerpattern.ISubject;

public abstract class AbstractSelfDescribingAlgorithm
extends AbstractAlgorithm
implements ISubject {
    private List<IObserver> observers = new ArrayList<IObserver>();
    private Object state = null;

    @Override
    protected ProcessDescriptionType initializeDescription() {
        ProcessDescriptionsDocument document = ProcessDescriptionsDocument.Factory.newInstance();
        ProcessDescriptionsDocument.ProcessDescriptions processDescriptions = document.addNewProcessDescriptions();
        ProcessDescriptionType processDescription = processDescriptions.addNewProcessDescription();
        processDescription.setStatusSupported(true);
        processDescription.setStoreSupported(true);
        processDescription.setProcessVersion("1.0.0");
        processDescription.addNewIdentifier().setStringValue(this.getClass().getName());
        processDescription.addNewTitle().setStringValue(this.getClass().getCanonicalName());
        List<String> identifiers = this.getInputIdentifiers();
        ProcessDescriptionType.DataInputs dataInputs = null;
        if (identifiers.size() > 0) {
            dataInputs = processDescription.addNewDataInputs();
        }
        for (String identifier : identifiers) {
            InputDescriptionType dataInput = dataInputs.addNewInput();
            dataInput.setMinOccurs(this.getMinOccurs(identifier));
            dataInput.setMaxOccurs(this.getMaxOccurs(identifier));
            dataInput.addNewIdentifier().setStringValue(identifier);
            dataInput.addNewTitle().setStringValue(identifier);
            Class<?> inputDataTypeClass = this.getInputDataType(identifier);
            Class<?>[] interfaces = inputDataTypeClass.getInterfaces();
            if (interfaces.length == 0) {
                interfaces = inputDataTypeClass.getSuperclass().getInterfaces();
            }
            for (Class<?> implementedInterface : interfaces) {
                if (implementedInterface.equals(ILiteralData.class)) {
                    Constructor<?>[] constructors;
                    LiteralInputType literalData = dataInput.addNewLiteralData();
                    String inputClassType = "";
                    for (Constructor<?> constructor : constructors = inputDataTypeClass.getConstructors()) {
                        Class<?>[] parameters = constructor.getParameterTypes();
                        if (parameters.length != 1) continue;
                        inputClassType = parameters[0].getSimpleName();
                    }
                    if (inputClassType.length() <= 0) continue;
                    DomainMetadataType datatype = literalData.addNewDataType();
                    datatype.setReference("xs:" + inputClassType.toLowerCase());
                    literalData.addNewAnyValue();
                    continue;
                }
                if (implementedInterface.equals(IBBOXData.class)) {
                    SupportedCRSsType bboxData = dataInput.addNewBoundingBoxData();
                    String[] supportedCRSAray = this.getSupportedCRSForBBOXInput(identifier);
                    for (int i = 0; i < supportedCRSAray.length; ++i) {
                        if (i == 0) {
                            SupportedCRSsType.Default defaultCRS = bboxData.addNewDefault();
                            defaultCRS.setCRS(supportedCRSAray[0]);
                            if (supportedCRSAray.length != 1) continue;
                            CRSsType supportedCRS = bboxData.addNewSupported();
                            supportedCRS.addCRS(supportedCRSAray[0]);
                            continue;
                        }
                        if (i == 1) {
                            CRSsType supportedCRS = bboxData.addNewSupported();
                            supportedCRS.addCRS(supportedCRSAray[1]);
                            continue;
                        }
                        bboxData.getSupported().addCRS(supportedCRSAray[i]);
                    }
                    continue;
                }
                if (!implementedInterface.equals(IComplexData.class)) continue;
                SupportedComplexDataInputType complexData = dataInput.addNewComplexData();
                List parsers = ParserFactory.getInstance().getAllParsers();
                ArrayList<IParser> foundParsers = new ArrayList<IParser>();
                for (IParser parser : parsers) {
                    Class[] supportedClasses;
                    for (Class clazz : supportedClasses = parser.getSupportedDataBindings()) {
                        if (!clazz.equals(inputDataTypeClass)) continue;
                        foundParsers.add(parser);
                    }
                }
                this.addInputFormats(complexData, foundParsers);
            }
        }
        ProcessDescriptionType.ProcessOutputs dataOutputs = processDescription.addNewProcessOutputs();
        List<String> outputIdentifiers = this.getOutputIdentifiers();
        for (String identifier : outputIdentifiers) {
            OutputDescriptionType dataOutput = dataOutputs.addNewOutput();
            dataOutput.addNewIdentifier().setStringValue(identifier);
            dataOutput.addNewTitle().setStringValue(identifier);
            dataOutput.addNewAbstract().setStringValue(identifier);
            Class<?> outputDataTypeClass = this.getOutputDataType(identifier);
            Class<?>[] interfaces = outputDataTypeClass.getInterfaces();
            if (interfaces.length == 0) {
                interfaces = outputDataTypeClass.getSuperclass().getInterfaces();
            }
            for (Class<?> implementedInterface : interfaces) {
                if (implementedInterface.equals(ILiteralData.class)) {
                    Constructor<?>[] constructors;
                    LiteralOutputType literalData = dataOutput.addNewLiteralOutput();
                    String outputClassType = "";
                    for (Constructor<?> constructor : constructors = outputDataTypeClass.getConstructors()) {
                        Class<?>[] parameters = constructor.getParameterTypes();
                        if (parameters.length != 1) continue;
                        outputClassType = parameters[0].getSimpleName();
                    }
                    if (outputClassType.length() <= 0) continue;
                    literalData.addNewDataType().setReference("xs:" + outputClassType.toLowerCase());
                    continue;
                }
                if (implementedInterface.equals(IBBOXData.class)) {
                    SupportedCRSsType bboxData = dataOutput.addNewBoundingBoxOutput();
                    String[] supportedCRSAray = this.getSupportedCRSForBBOXOutput(identifier);
                    for (int i = 0; i < supportedCRSAray.length; ++i) {
                        if (i == 0) {
                            SupportedCRSsType.Default defaultCRS = bboxData.addNewDefault();
                            defaultCRS.setCRS(supportedCRSAray[0]);
                            if (supportedCRSAray.length != 1) continue;
                            CRSsType cRSsType = bboxData.addNewSupported();
                            cRSsType.addCRS(supportedCRSAray[0]);
                            continue;
                        }
                        if (i == 1) {
                            CRSsType supportedCRS = bboxData.addNewSupported();
                            supportedCRS.addCRS(supportedCRSAray[1]);
                            continue;
                        }
                        bboxData.getSupported().addCRS(supportedCRSAray[i]);
                    }
                    continue;
                }
                if (!implementedInterface.equals(IComplexData.class)) continue;
                SupportedComplexDataType complexData = dataOutput.addNewComplexOutput();
                List generators = GeneratorFactory.getInstance().getAllGenerators();
                ArrayList<IGenerator> foundGenerators = new ArrayList<IGenerator>();
                for (IGenerator iGenerator : generators) {
                    Class[] supportedClasses;
                    for (Class clazz : supportedClasses = iGenerator.getSupportedDataBindings()) {
                        if (!clazz.equals(outputDataTypeClass)) continue;
                        foundGenerators.add(iGenerator);
                    }
                }
                this.addOutputFormats(complexData, foundGenerators);
            }
        }
        return document.getProcessDescriptions().getProcessDescriptionArray(0);
    }

    public String[] getSupportedCRSForBBOXInput(String identifier) {
        return new String[0];
    }

    public String[] getSupportedCRSForBBOXOutput(String identifier) {
        return new String[0];
    }

    public BigInteger getMinOccurs(String identifier) {
        return new BigInteger("1");
    }

    public BigInteger getMaxOccurs(String identifier) {
        return new BigInteger("1");
    }

    public abstract List<String> getInputIdentifiers();

    public abstract List<String> getOutputIdentifiers();

    public Object getState() {
        return this.state;
    }

    public void update(Object state) {
        this.state = state;
        this.notifyObservers();
    }

    public void addObserver(IObserver o) {
        this.observers.add(o);
    }

    public void removeObserver(IObserver o) {
        this.observers.remove(o);
    }

    public void notifyObservers() {
        for (IObserver o : this.observers) {
            o.update((ISubject)this);
        }
    }

    @Override
    public List<String> getErrors() {
        ArrayList<String> errors = new ArrayList<String>();
        return errors;
    }

    private void addInputFormats(SupportedComplexDataInputType complexData, List<IParser> foundParsers) {
        ComplexDataCombinationsType supportedInputFormat = complexData.addNewSupported();
        for (int i = 0; i < foundParsers.size(); ++i) {
            IParser parser = foundParsers.get(i);
            FormatDocument.Format[] supportedFullFormats = parser.getSupportedFullFormats();
            if (complexData.getDefault() == null) {
                String schema;
                ComplexDataCombinationType defaultInputFormat = complexData.addNewDefault();
                FormatDocument.Format format = supportedFullFormats[0];
                ComplexDataDescriptionType defaultFormat = defaultInputFormat.addNewFormat();
                defaultFormat.setMimeType(format.getMimetype());
                String encoding = format.getEncoding();
                if (encoding != null && !encoding.equals("")) {
                    defaultFormat.setEncoding(encoding);
                }
                if ((schema = format.getSchema()) != null && !schema.equals("")) {
                    defaultFormat.setSchema(schema);
                }
            }
            for (int j = 0; j < supportedFullFormats.length; ++j) {
                FormatDocument.Format format1 = supportedFullFormats[j];
                ComplexDataDescriptionType supportedFormat = supportedInputFormat.addNewFormat();
                supportedFormat.setMimeType(format1.getMimetype());
                if (format1.getEncoding() != null) {
                    supportedFormat.setEncoding(format1.getEncoding());
                }
                if (format1.getSchema() == null) continue;
                supportedFormat.setSchema(format1.getSchema());
            }
        }
    }

    private void addOutputFormats(SupportedComplexDataType complexData, List<IGenerator> foundGenerators) {
        ComplexDataCombinationsType supportedOutputFormat = complexData.addNewSupported();
        for (int i = 0; i < foundGenerators.size(); ++i) {
            IGenerator generator = foundGenerators.get(i);
            FormatDocument.Format[] supportedFullFormats = generator.getSupportedFullFormats();
            if (complexData.getDefault() == null) {
                String schema;
                ComplexDataCombinationType defaultInputFormat = complexData.addNewDefault();
                FormatDocument.Format format = supportedFullFormats[0];
                ComplexDataDescriptionType defaultFormat = defaultInputFormat.addNewFormat();
                defaultFormat.setMimeType(format.getMimetype());
                String encoding = format.getEncoding();
                if (encoding != null && !encoding.equals("")) {
                    defaultFormat.setEncoding(encoding);
                }
                if ((schema = format.getSchema()) != null && !schema.equals("")) {
                    defaultFormat.setSchema(schema);
                }
            }
            for (int j = 0; j < supportedFullFormats.length; ++j) {
                FormatDocument.Format format1 = supportedFullFormats[j];
                ComplexDataDescriptionType supportedFormat = supportedOutputFormat.addNewFormat();
                supportedFormat.setMimeType(format1.getMimetype());
                if (format1.getEncoding() != null) {
                    supportedFormat.setEncoding(format1.getEncoding());
                }
                if (format1.getSchema() == null) continue;
                supportedFormat.setSchema(format1.getSchema());
            }
        }
    }
}

