/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.algorithm.descriptor;

import com.google.common.base.Preconditions;
import java.math.BigInteger;
import org.n52.wps.algorithm.descriptor.InputDescriptor;
import org.n52.wps.io.data.IComplexData;

public class ComplexDataInputDescriptor<T extends Class<? extends IComplexData>>
extends InputDescriptor<T> {
    private final BigInteger maximumMegaBytes;

    private ComplexDataInputDescriptor(Builder builder) {
        super(builder);
        this.maximumMegaBytes = builder.maximumMegaBytes;
    }

    public boolean hasMaximumMegaBytes() {
        return this.maximumMegaBytes != null && this.maximumMegaBytes.longValue() > 0L;
    }

    public BigInteger getMaximumMegaBytes() {
        return this.maximumMegaBytes;
    }

    public static <T extends Class<? extends IComplexData>> Builder<?, T> builder(String identifier, T binding) {
        return new BuilderTyped<T>(identifier, binding);
    }

    public static abstract class Builder<B extends Builder<B, T>, T extends Class<? extends IComplexData>>
    extends InputDescriptor.Builder<B, T> {
        private BigInteger maximumMegaBytes;

        private Builder(String identifier, T binding) {
            super(identifier, binding);
        }

        public B maximumMegaBytes(int maximumMegaBytes) {
            return this.maximumMegaBytes(BigInteger.valueOf(maximumMegaBytes));
        }

        public B maximumMegaBytes(BigInteger maximumMegaBytes) {
            Preconditions.checkArgument((maximumMegaBytes.longValue() >= 0L ? 1 : 0) != 0, (Object)"maximumMegabytes must be >= 0");
            this.maximumMegaBytes = maximumMegaBytes;
            return (B)((Builder)this.self());
        }

        @Override
        public ComplexDataInputDescriptor<T> build() {
            return new ComplexDataInputDescriptor(this);
        }

        /* synthetic */ Builder(String x0, Class x1, 1 x2) {
            this(x0, x1);
        }
    }

    private static class BuilderTyped<T extends Class<? extends IComplexData>>
    extends Builder<BuilderTyped<T>, T> {
        public BuilderTyped(String identifier, T binding) {
            super(identifier, (Class)binding, null);
        }

        @Override
        protected BuilderTyped self() {
            return this;
        }
    }
}

