/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.algorithm.descriptor;

import com.google.common.base.Preconditions;
import java.math.BigInteger;
import org.n52.wps.algorithm.descriptor.BoundDescriptor;
import org.n52.wps.io.data.IData;

public abstract class InputDescriptor<T extends Class<? extends IData>>
extends BoundDescriptor<T> {
    private final BigInteger minOccurs;
    private final BigInteger maxOccurs;

    protected InputDescriptor(Builder<? extends Builder<?, T>, T> builder) {
        super(builder);
        this.minOccurs = ((Builder)builder).minOccurs;
        this.maxOccurs = ((Builder)builder).maxOccurs;
        Preconditions.checkState((this.maxOccurs.longValue() >= this.minOccurs.longValue() ? 1 : 0) != 0, (Object)"maxOccurs must be >= minOccurs");
    }

    public BigInteger getMinOccurs() {
        return this.minOccurs;
    }

    public BigInteger getMaxOccurs() {
        return this.maxOccurs;
    }

    public static abstract class Builder<B extends Builder<B, T>, T extends Class<? extends IData>>
    extends BoundDescriptor.Builder<B, T> {
        private BigInteger minOccurs = BigInteger.ONE;
        private BigInteger maxOccurs = BigInteger.ONE;

        protected Builder(String identifier, T binding) {
            super(identifier, binding);
        }

        public B minOccurs(int minOccurs) {
            return this.minOccurs(BigInteger.valueOf(minOccurs));
        }

        public B minOccurs(BigInteger minOccurs) {
            Preconditions.checkArgument((minOccurs.longValue() >= 0L ? 1 : 0) != 0, (Object)"minOccurs must be >= 0");
            this.minOccurs = minOccurs;
            return (B)((Builder)this.self());
        }

        public B maxOccurs(int maxOccurs) {
            return this.maxOccurs(BigInteger.valueOf(maxOccurs));
        }

        public B maxOccurs(BigInteger maxOccurs) {
            Preconditions.checkArgument((maxOccurs.longValue() > 0L ? 1 : 0) != 0, (Object)"maxOccurs must be > 0");
            this.maxOccurs = maxOccurs;
            return (B)((Builder)this.self());
        }

        public <E extends Enum<E>> B maxOccurs(Class<E> enumType) {
            return this.maxOccurs(((Enum[])enumType.getEnumConstants()).length);
        }

        public abstract InputDescriptor<T> build();
    }
}

