/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.lexicalmatcher.analysis.guesser.treeStructure.chunks;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.gcube.dataanalysis.lexicalmatcher.analysis.core.Engine;
import org.gcube.dataanalysis.lexicalmatcher.analysis.core.LexicalEngineConfiguration;
import org.gcube.dataanalysis.lexicalmatcher.analysis.guesser.data.DBObjectTranslator;
import org.gcube.dataanalysis.lexicalmatcher.analysis.guesser.treeStructure.chunks.ChunkSet;
import org.gcube.dataanalysis.lexicalmatcher.analysis.guesser.treeStructure.chunks.TimeSeriesChunk;
import org.gcube.dataanalysis.lexicalmatcher.utils.MathFunctions;
import org.hibernate.SessionFactory;

public class TimeSeriesChunkSet
extends ChunkSet {
    private String ColumnType = null;

    public TimeSeriesChunkSet(int MaxNumberOfChunks, int ChunkSize, String TimeSeriesName, String TimeSeriesColumn, LexicalEngineConfiguration config, Engine engine) throws Exception {
        super(MaxNumberOfChunks, ChunkSize, TimeSeriesName, TimeSeriesColumn, config, engine);
    }

    @Override
    protected BigDecimal calculateNumberOfElements() throws Exception {
        DBObjectTranslator dbo = new DBObjectTranslator();
        SessionFactory sess = this.engine.getDBSession();
        BigDecimal numberOfElements = new BigDecimal(dbo.calculateTotalEntries(sess, this.seriesName, this.seriesColumn));
        return numberOfElements;
    }

    @Override
    public TimeSeriesChunk nextChunk() {
        TimeSeriesChunk tsc = null;
        while (!this.chunkSet.contains(this.chunkIndex) && this.chunkIndex < this.chunkSetSize) {
            ++this.chunkIndex;
        }
        if (this.chunkIndex < this.chunkSetSize) {
            BigInteger startIndex = MathFunctions.chunk2Index(this.chunkIndex, this.chunkSize);
            try {
                tsc = new TimeSeriesChunk(this.seriesName, this.seriesColumn, this.ColumnType, startIndex, this.chunkSize, this.config, this.engine);
                if (this.ColumnType == null) {
                    this.ColumnType = tsc.getColumnType();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ++this.chunkIndex;
        return tsc;
    }
}

