/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.lexicalmatcher.analysis.core;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import org.gcube.dataanalysis.lexicalmatcher.analysis.guesser.data.Category;

public class LexicalEngineConfiguration {
    public float categoryDiscardThreshold = -1.4E-45f;
    public float entryAcceptanceThreshold = -1.4E-45f;
    public float categoryDiscardDifferencialThreshold = -1.4E-45f;
    public float singleEntryRecognitionMaxDeviation = -1.4E-45f;
    public int chunkSize = Integer.MIN_VALUE;
    public Boolean randomTake = null;
    public int TimeSeriesChunksToTake = Integer.MIN_VALUE;
    public int ReferenceChunksToTake = Integer.MIN_VALUE;
    public Boolean useSimpleDistance = null;
    public int numberOfThreadsToUse = Integer.MIN_VALUE;
    public String databaseDriver = null;
    public String databaseURL = null;
    public String databaseUserName = null;
    public String databasePassword = null;
    public String databaseDialect = null;
    public String databaseIdleConnectionTestPeriod = null;
    public String databaseAutomaticTestTable = null;
    public String referenceTable = null;
    public String referenceColumn = null;
    public String idColumn = null;
    public String nameHuman = null;
    public String description = null;
    public ArrayList<Category> categories = null;

    public void configure(String absoluteFilePath) throws Exception {
        Properties props = new Properties();
        FileInputStream fis = new FileInputStream(absoluteFilePath);
        props.load(fis);
        this.setProperties(props);
        fis.close();
    }

    public void configureByStream(String file) throws Exception {
        Properties props = new Properties();
        InputStream is = ClassLoader.getSystemResourceAsStream(file);
        props.load(is);
        this.setProperties(props);
        is.close();
    }

    private void setProperties(Properties props) {
        this.categoryDiscardThreshold = Float.parseFloat(props.getProperty("categoryDiscardThreshold"));
        this.entryAcceptanceThreshold = Integer.parseInt(props.getProperty("entryAcceptanceThreshold"));
        this.chunkSize = Integer.parseInt(props.getProperty("chunkSize"));
        this.TimeSeriesChunksToTake = Integer.parseInt(props.getProperty("timeSeriesChunksToTake"));
        this.ReferenceChunksToTake = Integer.parseInt(props.getProperty("referenceChunksToTake"));
        this.randomTake = Boolean.parseBoolean(props.getProperty("randomTake"));
        this.useSimpleDistance = Boolean.parseBoolean(props.getProperty("useSimpleDistance"));
        this.numberOfThreadsToUse = Integer.parseInt(props.getProperty("numberOfThreadsToUse"));
        this.categoryDiscardDifferencialThreshold = Float.parseFloat(props.getProperty("categoryDiscardDifferencialThreshold"));
        this.singleEntryRecognitionMaxDeviation = Float.parseFloat(props.getProperty("singleEntryRecognitionMaxDeviation"));
    }

    public void setCategoryDiscardThreshold(float categoryDiscardThreshold) {
        this.categoryDiscardThreshold = categoryDiscardThreshold;
    }

    public float getCategoryDiscardThreshold() {
        return this.categoryDiscardThreshold;
    }

    public void setEntryAcceptanceThreshold(float entryAcceptanceThreshold) {
        this.entryAcceptanceThreshold = entryAcceptanceThreshold;
    }

    public float getEntryAcceptanceThreshold() {
        return this.entryAcceptanceThreshold;
    }

    public void setCategoryDiscardDifferencialThreshold(float categoryDiscardDifferencialThreshold) {
        this.categoryDiscardDifferencialThreshold = categoryDiscardDifferencialThreshold;
    }

    public float getCategoryDiscardDifferencialThreshold() {
        return this.categoryDiscardDifferencialThreshold;
    }

    public void setChunkSize(int chunkSize) {
        this.chunkSize = chunkSize;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public void setRandomTake(boolean randomTake) {
        this.randomTake = randomTake;
    }

    public boolean isRandomTake() {
        return this.randomTake;
    }

    public void setTimeSeriesChunksToTake(int timeSeriesChunksToTake) {
        this.TimeSeriesChunksToTake = timeSeriesChunksToTake;
    }

    public int getTimeSeriesChunksToTake() {
        return this.TimeSeriesChunksToTake;
    }

    public void setReferenceChunksToTake(int referenceChunksToTake) {
        this.ReferenceChunksToTake = referenceChunksToTake;
    }

    public int getReferenceChunksToTake() {
        return this.ReferenceChunksToTake;
    }

    public void setUseSimpleDistance(boolean useSimpleDistance) {
        this.useSimpleDistance = useSimpleDistance;
    }

    public boolean isUseSimpleDistance() {
        return this.useSimpleDistance;
    }

    public void setNumberOfThreadsToUse(int numberOfThreadsToUse) {
        this.numberOfThreadsToUse = numberOfThreadsToUse;
    }

    public int getNumberOfThreadsToUse() {
        return this.numberOfThreadsToUse;
    }

    public void setSingleEntryRecognitionMaxDeviation(float singleEntryRecognitionMaxDeviation) {
        this.singleEntryRecognitionMaxDeviation = singleEntryRecognitionMaxDeviation;
    }

    public float getSingleEntryRecognitionMaxDeviation() {
        return this.singleEntryRecognitionMaxDeviation;
    }

    public void setCategories(ArrayList<Category> categories) {
        this.categories = categories;
    }

    public ArrayList<Category> getCategories() {
        return this.categories;
    }

    public void mergeConfig(LexicalEngineConfiguration config) {
        if (config.getCategoryDiscardDifferencialThreshold() != -1.4E-45f) {
            this.setCategoryDiscardDifferencialThreshold(config.getCategoryDiscardDifferencialThreshold());
        }
        if (config.getSingleEntryRecognitionMaxDeviation() != -1.4E-45f) {
            this.setSingleEntryRecognitionMaxDeviation(config.getSingleEntryRecognitionMaxDeviation());
        }
        if (config.getCategoryDiscardThreshold() != -1.4E-45f) {
            this.setCategoryDiscardThreshold(config.getCategoryDiscardThreshold());
        }
        if (config.getChunkSize() != Integer.MIN_VALUE) {
            this.setChunkSize(config.getChunkSize());
        }
        if (config.getEntryAcceptanceThreshold() != -1.4E-45f) {
            this.setEntryAcceptanceThreshold(config.getEntryAcceptanceThreshold());
        }
        if (config.getNumberOfThreadsToUse() != Integer.MIN_VALUE) {
            this.setNumberOfThreadsToUse(config.getNumberOfThreadsToUse());
        }
        if (config.getReferenceChunksToTake() != Integer.MIN_VALUE) {
            this.setReferenceChunksToTake(config.getReferenceChunksToTake());
        }
        if (config.getTimeSeriesChunksToTake() != Integer.MIN_VALUE) {
            this.setTimeSeriesChunksToTake(config.getTimeSeriesChunksToTake());
        }
        if (config.randomTake != null) {
            this.setRandomTake(config.isRandomTake());
        }
        if (config.useSimpleDistance != null) {
            this.setUseSimpleDistance(config.isUseSimpleDistance());
        }
        if (config.databaseDriver != null) {
            this.setDatabaseDriver(config.databaseDriver);
        }
        if (config.databaseDialect != null) {
            this.setDatabaseDialect(config.databaseDialect);
        }
        if (config.databaseAutomaticTestTable != null) {
            this.setDatabaseAutomaticTestTable(config.databaseAutomaticTestTable);
        }
        if (config.databaseIdleConnectionTestPeriod != null) {
            this.setDatabaseIdleConnectionTestPeriod(config.databaseIdleConnectionTestPeriod);
        }
        if (config.databaseUserName != null) {
            this.setDatabaseUserName(config.databaseUserName);
        }
        if (config.databasePassword != null) {
            this.setDatabasePassword(config.databasePassword);
        }
        if (config.databaseURL != null) {
            this.setDatabaseURL(config.databaseURL);
        }
        if (config.referenceTable != null) {
            this.setReferenceTable(config.referenceTable);
        }
        if (config.referenceColumn != null) {
            this.setReferenceColumn(config.referenceColumn);
        }
        if (config.idColumn != null) {
            this.setIdColumn(config.idColumn);
        }
        if (config.nameHuman != null) {
            this.setNameHuman(config.nameHuman);
        }
        if (config.description != null) {
            this.setDescription(config.description);
        }
    }

    public void setDatabaseDriver(String databaseDriver) {
        this.databaseDriver = databaseDriver;
    }

    public String getDatabaseDriver() {
        return this.databaseDriver;
    }

    public void setDatabaseURL(String databaseURL) {
        this.databaseURL = databaseURL;
    }

    public String getDatabaseURL() {
        return this.databaseURL;
    }

    public void setDatabaseUserName(String databaseUserName) {
        this.databaseUserName = databaseUserName;
    }

    public String getDatabaseUserName() {
        return this.databaseUserName;
    }

    public void setDatabasePassword(String databasePassword) {
        this.databasePassword = databasePassword;
    }

    public String getDatabasePassword() {
        return this.databasePassword;
    }

    public void setDatabaseDialect(String databaseDialect) {
        this.databaseDialect = databaseDialect;
    }

    public String getDatabaseDialect() {
        return this.databaseDialect;
    }

    public void setDatabaseIdleConnectionTestPeriod(String databaseIdleConnectionTestPeriod) {
        this.databaseIdleConnectionTestPeriod = databaseIdleConnectionTestPeriod;
    }

    public String getDatabaseIdleConnectionTestPeriod() {
        return this.databaseIdleConnectionTestPeriod;
    }

    public void setDatabaseAutomaticTestTable(String databaseAutomaticTestTable) {
        this.databaseAutomaticTestTable = databaseAutomaticTestTable;
    }

    public String getDatabaseAutomaticTestTable() {
        return this.databaseAutomaticTestTable;
    }

    public String getReferenceTable() {
        return this.referenceTable;
    }

    public void setReferenceTable(String referenceTable) {
        this.referenceTable = referenceTable;
    }

    public String getReferenceColumn() {
        return this.referenceColumn;
    }

    public void setReferenceColumn(String referenceColumn) {
        this.referenceColumn = referenceColumn;
    }

    public String getIdColumn() {
        return this.idColumn;
    }

    public void setIdColumn(String idColumn) {
        this.idColumn = idColumn;
    }

    public String getNameHuman() {
        return this.nameHuman;
    }

    public void setNameHuman(String nameHuman) {
        this.nameHuman = nameHuman;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

