/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.executor.messagequeue;

import java.util.UUID;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.TextMessage;
import org.gcube.dataanalysis.executor.messagequeue.ATTRIBUTE;
import org.gcube.dataanalysis.executor.messagequeue.QueueManager;

public class Producer {
    public MessageProducer producer;
    public QueueManager manager;
    public String topic;
    public String identifier;

    public Producer(QueueManager manager, String topic) throws JMSException {
        this.manager = manager;
        this.topic = topic;
        this.identifier = "" + UUID.randomUUID();
        this.create();
    }

    private void create() throws JMSException {
        this.producer = this.manager.session.createProducer(this.manager.destination);
        this.producer.setDeliveryMode(2);
    }

    public void sendTextMessage(String text, long timeToLive) throws JMSException {
        TextMessage message = this.manager.session.createTextMessage(text);
        this.producer.setTimeToLive(timeToLive);
        this.producer.send(message);
    }

    public void sendMessage(Object toSend, long timeToLive) throws JMSException {
        Message message = this.manager.session.createMessage();
        message.setObjectProperty(ATTRIBUTE.CONTENT.name(), toSend);
        this.producer.setTimeToLive(timeToLive);
        this.producer.send(message);
    }

    public void standBy() throws JMSException {
        this.producer.close();
    }

    public void wake() throws Exception {
        this.create();
    }

    public void stop() throws JMSException {
        if (this.producer != null) {
            this.producer.close();
        }
    }

    public void closeSession() throws JMSException {
        try {
            this.manager.closeSession();
            this.manager.connection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

