/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.executor.api.types;

import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.gcube.vremanagement.executor.api.types.Scheduling;
import org.gcube.vremanagement.executor.api.types.adapter.MapAdapter;
import org.gcube.vremanagement.executor.utils.MapCompare;
import org.gcube.vremanagement.executor.utils.ObjectCompare;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class LaunchParameter
implements Comparable<LaunchParameter> {
    @XmlElement
    protected String pluginName;
    @XmlElement
    protected String pluginVersion;
    @XmlJavaTypeAdapter(value=MapAdapter.class)
    protected Map<String, String> pluginCapabilities;
    @XmlJavaTypeAdapter(value=MapAdapter.class)
    protected Map<String, Object> inputs;
    @XmlElement
    protected Scheduling scheduling;
    @XmlElement
    @Deprecated
    protected boolean persist;

    protected LaunchParameter() {
    }

    public LaunchParameter(String pluginName, Map<String, Object> inputs) {
        this(pluginName, null, null, inputs, null);
    }

    public LaunchParameter(String pluginName, Map<String, String> pluginCapabilities, Map<String, Object> inputs) {
        this(pluginName, null, pluginCapabilities, inputs, null);
    }

    public LaunchParameter(String pluginName, Map<String, Object> inputs, Scheduling scheduling) {
        this(pluginName, null, null, inputs, scheduling);
    }

    public LaunchParameter(String pluginName, Map<String, String> pluginCapabilities, Map<String, Object> inputs, Scheduling scheduling) {
        this(pluginName, null, pluginCapabilities, inputs, scheduling);
    }

    public LaunchParameter(String pluginName, String pluginVersion, Map<String, String> pluginCapabilities, Map<String, Object> inputs, Scheduling scheduling) {
        this.pluginName = pluginName;
        this.pluginVersion = pluginVersion;
        this.pluginCapabilities = pluginCapabilities;
        this.inputs = inputs;
        this.scheduling = scheduling;
    }

    @Deprecated
    public LaunchParameter(String pluginName, Map<String, Object> inputs, Scheduling scheduling, boolean persist) {
        this(pluginName, null, null, inputs, scheduling);
        this.setPersist(persist);
    }

    @Deprecated
    public LaunchParameter(String pluginName, Map<String, String> pluginCapabilities, Map<String, Object> inputs, Scheduling scheduling, boolean persist) {
        this(pluginName, null, pluginCapabilities, inputs, scheduling);
        this.setPersist(persist);
    }

    @Deprecated
    public boolean isPersist() {
        return this.persist;
    }

    @Deprecated
    public void setPersist(boolean persist) {
        if (this.scheduling == null) {
            return;
        }
        if (this.scheduling.global == null) {
            this.scheduling.global = persist;
            this.persist = persist;
        } else {
            this.persist = this.scheduling.global;
        }
    }

    @Deprecated
    public String getName() {
        return this.getPluginName();
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public Map<String, String> getPluginCapabilities() {
        return this.pluginCapabilities;
    }

    public void setPluginCapabilities(Map<String, String> pluginCapabilities) {
        this.pluginCapabilities = pluginCapabilities;
    }

    public Map<String, Object> getInputs() {
        return this.inputs;
    }

    public Scheduling getScheduling() {
        return this.scheduling;
    }

    public void setScheduling(Scheduling scheduling) {
        this.scheduling = scheduling;
    }

    public String toString() {
        return String.format("%s : { Plugin : { Name: %s , Capabilites : %s}, Persist : %b, Scheduling : {%s}, Inputs : %s}", this.getClass().getSimpleName(), this.pluginName, this.pluginCapabilities, this.persist, this.scheduling, this.inputs);
    }

    @Override
    public int compareTo(LaunchParameter launchParameter) {
        int compareResult = 0;
        compareResult = new ObjectCompare<Boolean>().compare(new Boolean(this.persist), new Boolean(launchParameter.persist));
        if (compareResult != 0) {
            return compareResult;
        }
        compareResult = new ObjectCompare<String>().compare(this.pluginName, launchParameter.pluginName);
        if (compareResult != 0) {
            return compareResult;
        }
        compareResult = new ObjectCompare<Scheduling>().compare(this.scheduling, launchParameter.scheduling);
        if (compareResult != 0) {
            return compareResult;
        }
        return new MapCompare().compareMaps(this.inputs, launchParameter.inputs);
    }
}

