/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanager.storageclient.model.protocol.smp.external;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.apache.commons.codec.binary.Base64;
import org.gcube.contentmanager.storageclient.model.protocol.smp.SMPConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SMPURLConnectionById
extends SMPConnection {
    private Logger logger = LoggerFactory.getLogger(SMPURLConnectionById.class);
    private String serviceClass = "Storage-manager";
    private String serviceName = "resolver-uri";
    private String owner = "storage-manager-http-handler";
    private URLConnection urlConnection;

    public SMPURLConnectionById(URL url) {
        super(url);
    }

    public SMPURLConnectionById() {
        super(null);
    }

    @Override
    public URLConnection init(URL url) {
        URL httpUrl = null;
        try {
            httpUrl = this.translate(url);
        }
        catch (IOException e) {
            this.logger.error("problem to translate the following url: " + url);
            e.printStackTrace();
        }
        this.url = httpUrl;
        try {
            this.urlConnection = httpUrl.openConnection();
            return this.urlConnection;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private URL translate(URL url) throws IOException {
        this.logger.debug("translating: " + url);
        String urlString = url.toString().replace("smp://", "http://");
        String baseUrl = "http://" + url.getHost() + "/";
        this.logger.debug("base Url extracted is: " + baseUrl);
        int index = urlString.lastIndexOf(".org/");
        String params = urlString.substring(baseUrl.length());
        this.logger.debug("get params: " + baseUrl + " " + params);
        params = Base64.encodeBase64URLSafeString(params.getBytes("UTF-8"));
        urlString = baseUrl + params;
        this.logger.info("uri translated in http url: " + urlString);
        return new URL(urlString);
    }

    @Override
    public synchronized InputStream getInputStream() throws IOException {
        return this.urlConnection.getInputStream();
    }

    @Override
    protected InputStream storageClient(String url) throws Exception {
        this.logger.error("bad method invoked");
        return null;
    }
}

