/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.executor.plugin;

import java.util.UUID;
import javax.xml.bind.annotation.XmlElement;
import org.gcube.vremanagement.executor.exception.InvalidPluginStateEvolutionException;
import org.gcube.vremanagement.executor.plugin.PluginDeclaration;
import org.gcube.vremanagement.executor.plugin.PluginState;

public class PluginStateEvolution {
    @XmlElement
    protected UUID uuid;
    @XmlElement
    protected int iteration;
    @XmlElement
    protected long timestamp;
    protected PluginDeclaration pluginDeclaration;
    @XmlElement
    protected PluginState pluginState;
    @XmlElement
    protected int percentage;

    public PluginStateEvolution() {
    }

    public PluginStateEvolution(UUID uuid, int iteration, long timestamp, PluginDeclaration pluginDeclaration, PluginState pluginState, Integer percentage) throws InvalidPluginStateEvolutionException {
        this.uuid = uuid;
        this.iteration = iteration;
        this.timestamp = timestamp;
        this.pluginDeclaration = pluginDeclaration;
        this.pluginState = pluginState;
        switch (pluginState) {
            case CREATED: {
                this.percentage = 0;
                break;
            }
            default: {
                if (percentage < 0 || percentage > 100) {
                    throw new InvalidPluginStateEvolutionException("Percentage must be beetween 0 and 100");
                }
                this.percentage = percentage;
            }
        }
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public int getIteration() {
        return this.iteration;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public PluginDeclaration getPluginDeclaration() {
        return this.pluginDeclaration;
    }

    public PluginState getPluginState() {
        return this.pluginState;
    }

    public Integer getPercentage() {
        return this.percentage;
    }

    public String toString() {
        return String.format("%s : { %s : %s - iteration : %d - timestamp - %d - {%s} - %s - Percentage : %d }}", this.getClass().getSimpleName(), this.uuid.getClass().getSimpleName(), this.uuid.toString(), this.iteration, this.timestamp, this.pluginDeclaration, this.pluginState.toString(), this.percentage);
    }
}

