/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ewe;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Calendar;
import java.util.UUID;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FileUtils;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveType;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.PrimitiveTypes;
import org.gcube.dataanalysis.ecoengine.interfaces.StandardLocalInfraAlgorithm;
import org.gcube.dataanalysis.ewe.notification.NotificationHelper;
import org.gcube.dataanalysis.ewe.util.Workspace;
import org.gcube.dataanalysis.ewe.util.ZipUtils;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SimpleEwE
extends StandardLocalInfraAlgorithm {
    private static final String EWE_MODEL_DOWNLOAD_LOCATION = "http://goo.gl/hBc8UN";
    private static final String EWE_MODEL_DEST_PKGNAME = "EwECmd.zip";
    private static final String EWE_EXE_FILE = "EwECmd.exe";
    private static final String INPUT_LOCATION = ".";
    private static final String OUTPUT_LOCATION = ".";
    private static final String BINARIES_LOCATION = "bin";
    private static final String IN_MODEL_FILE = "Model File";
    private static final String IN_CONFIG_FILE = "Config File";
    private static final String IN_MODEL_FILE_DESCRIPTION = "A file containing the model (e.g. Georgia_Strait.eiixml)";
    private static final String IN_CONFIG_FILE_DESCRIPTION = "A file containing execution parameters (e.g. run_config.xml)";
    private static String IN_CONFIG_FILE_EXPECTED_NAME = "run_config.xml";
    private static final String OUT_RUN_LOG_FILENAME = "run_log.txt";
    private static final String MODEL_FILE_TAG_NAME = "model_file";
    private String executionId;
    private Workspace workspace;
    private NotificationHelper notificationHelper;

    public void init() throws Exception {
        AnalysisLogger.getLogger().info((Object)"EwE Initialisation");
        AnalysisLogger.getLogger().info((Object)this.getDescription());
        this.executionId = "ewe_model_" + UUID.randomUUID().toString();
        this.workspace = new Workspace(this.getExecutionId());
        this.workspace.setExecutionsRoot(this.config.getConfigPath());
        this.workspace.setBinariesLocation(BINARIES_LOCATION);
        this.workspace.setInputLocation(".");
        this.workspace.setOutputLocation(".");
        this.notificationHelper = new NotificationHelper();
        this.notificationHelper.setScope(this.config.getGcubeScope());
        this.notificationHelper.setStartTime(Calendar.getInstance());
        this.notificationHelper.setTaskId(this.config.getTaskID());
    }

    public String getDescription() {
        String description = "Ecopath with Ecosim (EwE) is a free ecological/ecosystem modeling software suite. ";
        description = description + " This algorithm implementation expects a model and a configuration file as inputs; the result of the analysis is returned as a zip archive.";
        description = description + " References: Christensen, V., & Walters, C. J. (2004). Ecopath with Ecosim: methods, capabilities and limitations. Ecological modelling, 172(2), 109-139.";
        return description;
    }

    protected void setInputParameters() {
        this.inputs.add(new PrimitiveType(File.class.getName(), null, PrimitiveTypes.FILE, IN_MODEL_FILE, IN_MODEL_FILE_DESCRIPTION));
        this.inputs.add(new PrimitiveType(File.class.getName(), null, PrimitiveTypes.FILE, IN_CONFIG_FILE, IN_CONFIG_FILE_DESCRIPTION));
    }

    private void prepareInput() throws Exception {
        AnalysisLogger.getLogger().debug((Object)"Copying input files...");
        FileUtils.copyFile((File)new File(this.config.getParam(IN_CONFIG_FILE)), (File)new File(this.workspace.getInputLocation(), IN_CONFIG_FILE_EXPECTED_NAME));
        String modelFileName = this.extractModelFileNameFromConfigFile(new File(this.workspace.getInputLocation(), IN_CONFIG_FILE_EXPECTED_NAME));
        FileUtils.copyFile((File)new File(this.config.getParam(IN_MODEL_FILE)), (File)new File(this.workspace.getRoot(), modelFileName));
    }

    private String extractModelFileNameFromConfigFile(File config_file) throws Exception {
        DocumentBuilder builder;
        AnalysisLogger.getLogger().debug((Object)("Extracting model file name from " + config_file));
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            AnalysisLogger.getLogger().error((Object)e);
            throw new Exception(e);
        }
        Document doc = null;
        try {
            doc = builder.parse(config_file);
        }
        catch (SAXException e) {
            AnalysisLogger.getLogger().error((Object)e);
            throw new Exception("Unable to parse the configuration file. Is it an xml file?");
        }
        catch (IOException e) {
            AnalysisLogger.getLogger().error((Object)e);
            throw new Exception("I/O problem in accessing the configuration file");
        }
        doc.getDocumentElement().normalize();
        NodeList nList = doc.getElementsByTagName(MODEL_FILE_TAG_NAME);
        String out = null;
        if (nList.getLength() == 0) {
            AnalysisLogger.getLogger().error((Object)"Can't find a tag named 'model_file' in the configuration file");
            throw new Exception("Unable to extract model name from the configuration file");
        }
        out = nList.item(0).getTextContent();
        if (nList.getLength() > 1) {
            AnalysisLogger.getLogger().warn((Object)("More than one model name found. Returning the first: " + out));
        }
        AnalysisLogger.getLogger().debug((Object)("Model file name is " + out));
        System.out.println(out);
        return out;
    }

    private String getExecutionId() {
        return this.executionId;
    }

    protected void process() throws Exception {
        try {
            this.setupWorkingDirectory();
            this.prepareInput();
            this.downloadAndSetupEwE();
            String command = String.format("mono %s/%s %s/%s", this.workspace.getBinariesLocation(), EWE_EXE_FILE, this.workspace.getInputLocation(), IN_CONFIG_FILE_EXPECTED_NAME);
            AnalysisLogger.getLogger().debug((Object)("Executing '" + command + "'"));
            this.workspace.exec(command, null, "stdout-stderr.log");
            this.prepareOutput();
            this.checkForErrors(this.workspace.getRoot());
        }
        catch (Exception e) {
            e.printStackTrace();
            AnalysisLogger.getLogger().error((Object)e);
            this.notificationHelper.setExecutionException(e);
            this.notifySubmitter();
            throw e;
        }
        finally {
            this.removeWorkingDirectory();
        }
        this.notifySubmitter();
    }

    private void setupWorkingDirectory() throws Exception {
        AnalysisLogger.getLogger().debug((Object)("Setting up working directory '" + this.workspace.getRoot() + "'"));
        this.workspace.ensureStructureExists();
    }

    private void downloadAndSetupEwE() throws Exception {
        AnalysisLogger.getLogger().debug((Object)"Downloading EwE package");
        if (EWE_MODEL_DOWNLOAD_LOCATION.startsWith("http")) {
            FileUtils.copyURLToFile((URL)new URL(EWE_MODEL_DOWNLOAD_LOCATION), (File)new File(this.workspace.getBinariesLocation(), EWE_MODEL_DEST_PKGNAME));
        } else {
            FileUtils.copyFile((File)new File(EWE_MODEL_DOWNLOAD_LOCATION), (File)new File(this.workspace.getBinariesLocation(), EWE_MODEL_DEST_PKGNAME));
        }
        ZipUtils.unzipFile(new File(this.workspace.getBinariesLocation(), EWE_MODEL_DEST_PKGNAME), this.workspace.getBinariesLocation());
    }

    private void checkForErrors(File executionRoot) throws Exception {
        File runLog = new File(executionRoot, OUT_RUN_LOG_FILENAME);
        FileInputStream fis = new FileInputStream(runLog);
        BufferedReader br = new BufferedReader(new InputStreamReader(fis));
        String line = null;
        Exception e = null;
        while ((line = br.readLine()) != null) {
            if (!"Ecopath model failed to load".equalsIgnoreCase(line)) continue;
            e = new Exception("Ecopath model failed to load");
        }
        br.close();
        if (e != null) {
            throw e;
        }
    }

    protected void prepareOutput() throws Exception {
        File outputZip = new File(this.config.getPersistencePath(), this.getOutputFileName());
        ZipUtils.zipFolder(this.workspace.getRoot(), outputZip, new String[]{this.workspace.getBinariesLocation().getName()});
    }

    private String getOutputFileName() {
        return this.getExecutionId() + "-output.zip";
    }

    private void removeWorkingDirectory() throws Exception {
        AnalysisLogger.getLogger().debug((Object)"Removing working directory");
        this.workspace.destroy();
    }

    public StatisticalType getOutput() {
        String outputFileName = this.config.getPersistencePath() + "/" + this.getOutputFileName();
        PrimitiveType file = new PrimitiveType(File.class.getName(), (Object)new File(outputFileName), PrimitiveTypes.FILE, "OutputFile ", "An archive containing all output files");
        return file;
    }

    public void shutdown() {
        AnalysisLogger.getLogger().info((Object)"Shutdown");
    }

    private void notifySubmitter() throws Exception {
        AnalysisLogger.getLogger().info((Object)"notifying submitter ...");
        AnalysisLogger.getLogger().debug((Object)this.notificationHelper.getSubject());
        AnalysisLogger.getLogger().debug((Object)this.notificationHelper.getBody());
        super.sendNotification(this.notificationHelper.getSubject(), this.notificationHelper.getBody());
    }
}

