/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.gcubelogin.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import com.liferay.portal.NoSuchRoleException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.servlet.ImageServletTokenUtil;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.Theme;
import com.liferay.portal.model.User;
import com.liferay.portal.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import com.liferay.portal.service.ThemeLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.portal.custom.communitymanager.OrganizationsUtil;
import org.gcube.portal.custom.communitymanager.PortletsIdManager;
import org.gcube.portal.custom.communitymanager.components.GCUBELayoutTab;
import org.gcube.portal.custom.communitymanager.components.GCUBEPortlet;
import org.gcube.portal.custom.communitymanager.components.GCUBESiteLayout;
import org.gcube.portal.custom.communitymanager.impl.OrganizationManagerImpl;
import org.gcube.portal.custom.communitymanager.types.GCUBELayoutType;
import org.gcube.portlets.user.gcubelogin.client.stubs.NewLoginService;
import org.gcube.portlets.user.gcubelogin.server.LoginServiceImpl;
import org.gcube.portlets.user.gcubelogin.server.LoginServiceUtil;
import org.gcube.portlets.user.gcubelogin.shared.CheckResult;
import org.gcube.portlets.user.gcubelogin.shared.ResearchEnvironment;
import org.gcube.portlets.user.gcubelogin.shared.SelectedTheme;
import org.gcube.portlets.user.gcubelogin.shared.UserBelonging;
import org.gcube.portlets.user.gcubelogin.shared.VO;
import org.gcube.portlets.user.gcubelogin.shared.VRE;

public class LoginServiceImpl
extends RemoteServiceServlet
implements NewLoginService {
    public static final String CACHED_VOS = "CACHED_VOS";
    public String SELECTED_THEMEID = "";
    private static final long serialVersionUID = 6776921559146742541L;
    private VO rootVO = new VO();
    private boolean withinPortal = false;
    private static GCUBELog _log = new GCUBELog(LoginServiceImpl.class);

    private ASLSession getASLSession() {
        String sessionID = this.getThreadLocalRequest().getSession().getId();
        String user = (String)this.getThreadLocalRequest().getSession().getAttribute("username");
        if (user == null) {
            _log.warn((Object)"USER IS NULL setting test.user");
            user = "test.user";
        } else {
            this.withinPortal = true;
            _log.info((Object)("LIFERAY PORTAL DETECTED user=" + user));
        }
        return SessionManager.getInstance().getASLSession(sessionID, user);
    }

    public ArrayList<VO> getInfrastructureVOs() {
        _log.trace((Object)"getInfrastructureVOs method called");
        if (!this.withinPortal) {
            return LoginServiceUtil.getFakeVOs();
        }
        try {
            User currUser = OrganizationsUtil.validateUser((String)this.getASLSession().getUsername());
            List organizations = OrganizationLocalServiceUtil.getOrganizations((int)0, (int)OrganizationLocalServiceUtil.getOrganizationsCount());
            ThemeDisplay themeDisplay = (ThemeDisplay)this.getThreadLocalRequest().getSession().getAttribute("THEME_DISPLAY");
            Organization rootOrganization = null;
            for (Organization organization : organizations) {
                if (!organization.getName().equals(LoginServiceUtil.getRootOrganizationName())) continue;
                rootOrganization = organization;
                break;
            }
            try {
                _log.info((Object)("root: " + rootOrganization.getName()));
            }
            catch (NullPointerException e) {
                _log.error((Object)"Cannot find root organziation, please check gcube-data.properties file in $CATALINA_HOME/conf folder, unless your installing the Bundle");
                return new ArrayList<VO>();
            }
            ArrayList<VO> infrastructureVOs = new ArrayList<VO>();
            this.rootVO = new VO();
            this.rootVO.setName(rootOrganization.getName());
            this.rootVO.setGroupName("/" + rootOrganization.getName());
            this.rootVO.setRoot(true);
            Group orgGroup = rootOrganization.getGroup();
            String friendlyURL = orgGroup.getPathFriendlyURL(true, themeDisplay) + orgGroup.getFriendlyURL();
            this.rootVO.setFriendlyURL(this.getPortalBasicUrl() + friendlyURL);
            long logoId = rootOrganization.getLogoId();
            String logoURL = themeDisplay.getPathImage() + "/organization_logo?img_id=" + logoId + "&t" + ImageServletTokenUtil.getToken((long)logoId);
            this.rootVO.setImageURL(logoURL);
            if (rootOrganization.getComments() != null) {
                this.rootVO.setDescription(rootOrganization.getComments());
            }
            if (this.hasRole(this.getVoAdminRoleName(), rootOrganization.getName(), currUser)) {
                this.rootVO.setUserBelonging(UserBelonging.BELONGING);
            } else if (LoginServiceUtil.checkPending((String)currUser.getScreenName(), (long)rootOrganization.getOrganizationId())) {
                this.rootVO.setUserBelonging(UserBelonging.PENDING);
            } else {
                this.rootVO.setUserBelonging(UserBelonging.NOT_BELONGING);
            }
            for (Organization vOrg : rootOrganization.getSuborganizations()) {
                if (vOrg.getName().compareTo("gCubeApps") == 0) continue;
                _log.debug((Object)("SKIP GCUBE APPS " + vOrg.getName()));
                _log.debug((Object)("FOUND VO: " + vOrg.getName()));
                VO voToAdd = new VO();
                voToAdd.setName(vOrg.getName());
                voToAdd.setGroupName("/" + vOrg.getParentOrganization().getName() + "/" + vOrg.getName());
                voToAdd.setRoot(false);
                for (VRE vre : vOrg.getSuborganizations()) {
                    VRE vreToAdd = new VRE();
                    vreToAdd.setName(vre.getName());
                    vreToAdd.setGroupName("/" + vOrg.getParentOrganization().getName() + "/" + vOrg.getName() + "/" + vre.getName());
                    logoId = vre.getLogoId();
                    logoURL = themeDisplay.getPathImage() + "/organization_logo?img_id=" + logoId + "&t" + ImageServletTokenUtil.getToken((long)logoId);
                    vreToAdd.setImageURL(logoURL);
                    String vreUrl = vre.getGroup().getPathFriendlyURL(true, themeDisplay) + vre.getGroup().getFriendlyURL();
                    vreToAdd.setFriendlyURL(this.getPortalBasicUrl() + vreUrl);
                    if (vre.getComments() != null) {
                        vreToAdd.setDescription(vre.getComments());
                    }
                    if (currUser.getOrganizations().contains(vre)) {
                        vreToAdd.setUserBelonging(UserBelonging.BELONGING);
                    } else if (LoginServiceUtil.checkPending((String)currUser.getScreenName(), (long)vre.getOrganizationId())) {
                        vreToAdd.setUserBelonging(UserBelonging.PENDING);
                    } else {
                        vreToAdd.setUserBelonging(UserBelonging.NOT_BELONGING);
                    }
                    voToAdd.addVRE(vreToAdd);
                }
                Group group = vOrg.getGroup();
                String url = group.getPathFriendlyURL(true, themeDisplay) + group.getFriendlyURL();
                voToAdd.setFriendlyURL(this.getPortalBasicUrl() + url);
                if (vOrg.getComments() != null) {
                    voToAdd.setDescription(vOrg.getComments());
                }
                if (currUser.getOrganizations().contains(vOrg)) {
                    voToAdd.setUserBelonging(UserBelonging.BELONGING);
                } else if (LoginServiceUtil.checkPending((String)currUser.getScreenName(), (long)vOrg.getOrganizationId())) {
                    voToAdd.setUserBelonging(UserBelonging.PENDING);
                } else {
                    voToAdd.setUserBelonging(UserBelonging.NOT_BELONGING);
                }
                infrastructureVOs.add(voToAdd);
            }
            ArrayList<VO> toReturn = new ArrayList<VO>();
            for (VO vo : infrastructureVOs) {
                for (VRE vre : vo.getVres()) {
                    _log.debug((Object)("VRE FOUND.... " + vre.getName()));
                }
                toReturn.add(vo);
            }
            Collections.sort(toReturn, Collections.reverseOrder());
            toReturn.add(0, this.rootVO);
            ArrayList<VO> toStoreInSession = toReturn;
            _log.debug((Object)"SETTING INFRASTRUCTURE VOS in ASLSession");
            this.getASLSession().setAttribute(CACHED_VOS, toStoreInSession);
            return toReturn;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<VO>();
        }
    }

    public void addMembershipRequest(String scope, String optionalMessage) {
        String username = this.getASLSession().getUsername();
        LoginServiceUtil.addMembershipRequest((String)username, (VO)this.rootVO, (String)scope, (String)optionalMessage, (String)this.getPortalBasicUrl());
    }

    private long createRootVO(String rootVoName, String themeid) throws PortalException, SystemException {
        OrganizationManagerImpl orgManager = OrganizationManagerImpl.getInstance((ASLSession)this.getASLSession());
        GCUBESiteLayout siteLayout = this.getBaseLayout(rootVoName, orgManager, true);
        GCUBELayoutTab accounting = new GCUBELayoutTab("Accounting", GCUBELayoutType.ONE_COL, new GCUBEPortlet("Navigation", PortletsIdManager.getLRPortletId((String)"LR_navigation")));
        GCUBELayoutTab portalAccounting = new GCUBELayoutTab("Portal Accounting", GCUBELayoutType.ONE_COL, new GCUBEPortlet("PortalAccounting", PortletsIdManager.getLRPortletId((String)"portalaccounting")));
        GCUBELayoutTab nodeAccounting = new GCUBELayoutTab("Node Accounting", GCUBELayoutType.ONE_COL, new GCUBEPortlet("PortalAccounting", PortletsIdManager.getLRPortletId((String)"nodeaccounting")));
        accounting.addSubTab(portalAccounting);
        accounting.addSubTab(nodeAccounting);
        siteLayout.addTab(accounting);
        siteLayout.addTab(new GCUBELayoutTab("Services Availability", GCUBELayoutType.ONE_COL, new GCUBEPortlet("Services", PortletsIdManager.getLRPortletId((String)"servicesaccounting"))));
        siteLayout.addTab(new GCUBELayoutTab("Monitoring", GCUBELayoutType.ONE_COL, new GCUBEPortlet("Monitoring", PortletsIdManager.getLRPortletId((String)"ecomonitoring"))));
        return orgManager.createVO(rootVoName, "desc", siteLayout, themeid);
    }

    private long createVO(String voName, long parentid, String themeid) throws PortalException, SystemException {
        OrganizationManagerImpl orgManager = OrganizationManagerImpl.getInstance((ASLSession)this.getASLSession());
        GCUBESiteLayout siteLayout = this.getBaseLayout(voName, orgManager, true);
        GCUBELayoutTab vreManagementTab = new GCUBELayoutTab("VRE Management", GCUBELayoutType.ONE_COL, new GCUBEPortlet("VRE Management", PortletsIdManager.getLRPortletId((String)"LR_navigation")));
        GCUBELayoutTab vreDefinitionTab = new GCUBELayoutTab("VRE Definition", GCUBELayoutType.ONE_COL, new GCUBEPortlet("VRE Definition", PortletsIdManager.getLRPortletId((String)"vredefinition")));
        GCUBELayoutTab vreDeploymentTab = new GCUBELayoutTab("VRE Deployment", GCUBELayoutType.ONE_COL, new GCUBEPortlet("VRE Deployment", PortletsIdManager.getLRPortletId((String)"vredeployment")));
        GCUBELayoutTab vreDeployerTab = new GCUBELayoutTab("VRE Deployer", GCUBELayoutType.ONE_COL, new GCUBEPortlet("VRE Deployer", PortletsIdManager.getLRPortletId((String)"vredeployer")));
        vreDeployerTab.setHidden(true);
        vreManagementTab.addSubTab(vreDefinitionTab);
        vreManagementTab.addSubTab(vreDeploymentTab);
        vreManagementTab.addSubTab(vreDeployerTab);
        siteLayout.addTab(vreManagementTab);
        return orgManager.createVO(voName, "desc", parentid, siteLayout, themeid);
    }

    private long createVRE(String vreName, String desc, long parentid, String themeid) throws PortalException, SystemException {
        OrganizationManagerImpl orgManager = OrganizationManagerImpl.getInstance((ASLSession)this.getASLSession());
        GCUBESiteLayout siteLayout = this.getBaseLayout(vreName, orgManager, false);
        return orgManager.createVRE(vreName, desc, parentid, siteLayout, themeid);
    }

    private GCUBESiteLayout getBaseLayout(String voName, OrganizationManagerImpl orgManager, boolean isVO) throws PortalException, SystemException {
        GCUBESiteLayout siteLayout = null;
        String email = OrganizationManagerImpl.validateUser((String)this.getASLSession().getUsername()).getEmailAddress();
        siteLayout = new GCUBESiteLayout(OrganizationManagerImpl.getCompany(), voName, email);
        siteLayout.addTab(new GCUBELayoutTab("Home", GCUBELayoutType.ONE_COL, new GCUBEPortlet("gCube Loggedin", PortletsIdManager.getLRPortletId((String)"gCubeLoggedin"))));
        GCUBELayoutTab usersAndRoles = new GCUBELayoutTab("Users and Roles", GCUBELayoutType.ONE_COL, new GCUBEPortlet("Navigation", PortletsIdManager.getLRPortletId((String)"LR_navigation")));
        GCUBELayoutTab usersTab = new GCUBELayoutTab("Manage Users", GCUBELayoutType.ONE_COL, new GCUBEPortlet("Users", PortletsIdManager.getLRPortletId((String)"usersManagement")));
        GCUBELayoutTab rolesTab = new GCUBELayoutTab("Manage Roles", GCUBELayoutType.ONE_COL, new GCUBEPortlet("Roles", PortletsIdManager.getLRPortletId((String)"rolesManagement")));
        usersAndRoles.addSubTab(usersTab);
        usersAndRoles.addSubTab(rolesTab);
        siteLayout.addTab(usersAndRoles);
        if (isVO) {
            siteLayout.addTab(new GCUBELayoutTab("Resources Management", GCUBELayoutType.ONE_COL, new GCUBEPortlet("Resources Management", PortletsIdManager.getLRPortletId((String)"gCubeRM"))));
        } else {
            siteLayout.addTab(new GCUBELayoutTab("Workspace", GCUBELayoutType.ONE_COL, new GCUBEPortlet("Workspace", PortletsIdManager.getLRPortletId((String)"WorkspacePortlet"))));
        }
        return siteLayout;
    }

    public String[] getConfigFromGCore() {
        String[] toReturn = new String[2];
        GHNContext ctx = GHNContext.getContext();
        toReturn[0] = (String)ctx.getProperty("infrastructure", new boolean[]{true});
        toReturn[1] = (String)ctx.getProperty("startScopes", new boolean[]{true});
        return toReturn;
    }

    private String getPortalBasicUrl() {
        HttpServletRequest request = this.getThreadLocalRequest();
        String toReturn = "";
        String protocol = request.isSecure() ? "https://" : "http://";
        toReturn = toReturn + protocol;
        toReturn = toReturn + request.getServerName();
        toReturn = toReturn + (request.getServerPort() == 80 ? "" : ":" + request.getServerPort());
        _log.trace((Object)("getPortalBasicUrl: " + toReturn + "queryString: " + request.getQueryString()));
        return toReturn;
    }

    public VO getRootVO() {
        _log.debug((Object)"root called");
        this.getASLSession().invalidate();
        if (this.rootVO != null) {
            return this.rootVO;
        }
        Organization rootOrganization = null;
        List organizations = null;
        try {
            organizations = OrganizationLocalServiceUtil.getOrganizations((int)0, (int)OrganizationLocalServiceUtil.getOrganizationsCount());
        }
        catch (SystemException e) {
            e.printStackTrace();
        }
        for (Organization organization : organizations) {
            if (!organization.getName().equals(LoginServiceUtil.getRootOrganizationName())) continue;
            rootOrganization = organization;
            break;
        }
        this.rootVO.setName(rootOrganization.getName());
        this.rootVO.setGroupName("/" + rootOrganization.getName());
        this.rootVO.setRoot(true);
        ThemeDisplay themeDisplay = (ThemeDisplay)this.getThreadLocalRequest().getSession().getAttribute("THEME_DISPLAY");
        Group orgGroup = rootOrganization.getGroup();
        String friendlyURL = orgGroup.getPathFriendlyURL(true, themeDisplay) + orgGroup.getFriendlyURL();
        this.rootVO.setFriendlyURL(this.getPortalBasicUrl() + friendlyURL);
        return this.rootVO;
    }

    public ResearchEnvironment getSelectedRE() {
        _log.debug((Object)"getting Selected Research Environment");
        HttpSession session = this.getThreadLocalRequest().getSession();
        String selectedGroupName = this.getASLSession().getScopeName();
        ArrayList vos = (ArrayList)session.getAttribute(CACHED_VOS);
        for (VO vo : vos) {
            if (vo.getGroupName().equals(selectedGroupName)) {
                return vo;
            }
            ArrayList vres = vo.getVres();
            for (VRE vre : vres) {
                if (!vre.getGroupName().equals(selectedGroupName)) continue;
                this.setVREBelonginApplication(vre);
                return new ResearchEnvironment(vre.getName(), vre.getDescription(), vre.getImageURL(), vre.getGroupName(), vre.getFriendlyURL(), vre.getUserBelonging());
            }
        }
        return null;
    }

    private String getVoAdminRoleName() {
        Properties props = new Properties();
        String toReturn = "";
        try {
            String propertyfile = OrganizationsUtil.getTomcatFolder() + "conf/gcube-data.properties";
            File propsFile = new File(propertyfile);
            FileInputStream fis = new FileInputStream(propsFile);
            props.load(fis);
            toReturn = props.getProperty("voadminRole");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    private boolean hasRole(String rolename, String organizationName, User user) throws SystemException {
        for (Role role : user.getRoles()) {
            if (role.getName().compareTo(rolename + "-" + organizationName) != 0) continue;
            return true;
        }
        return false;
    }

    public Boolean installPortalEnv(String infrastructure, String startScopes, SelectedTheme theme, boolean automaticRedirect) {
        String rootVoName;
        block12: {
            String[] organizations;
            rootVoName = infrastructure.replaceAll(" ", "");
            if (startScopes.contains(",")) {
                organizations = startScopes.split(",");
                for (int i = 0; i < organizations.length; ++i) {
                    organizations[i] = organizations[i].replaceAll(" ", "");
                }
            } else {
                organizations = new String[]{startScopes.replaceAll(" ", "")};
            }
            _log.info((Object)("Starting create Root VO for infrastructure " + this.rootVO));
            try {
                if (LoginServiceUtil.setupGuestCommunity((SelectedTheme)theme)) {
                    String themid = "";
                    boolean applyTheme = true;
                    switch (1.$SwitchMap$org$gcube$portlets$user$gcubelogin$shared$SelectedTheme[theme.ordinal()]) {
                        case 1: {
                            themid = OrganizationsUtil.getgCubeThemeId((String)"gcubeportaltheme");
                            break;
                        }
                        case 2: {
                            themid = OrganizationsUtil.getgCubeThemeId((String)"imarineportaltheme");
                            break;
                        }
                        default: {
                            applyTheme = false;
                            _log.info((Object)"User chose liferay theme");
                        }
                    }
                    this.SELECTED_THEMEID = themid;
                    long parentid = this.createRootVO(rootVoName, themid);
                    _log.info((Object)("Root VO for infrastructure " + rootVoName + " Created with Success id: " + parentid + " themid:" + this.SELECTED_THEMEID));
                    for (int i = 0; i < organizations.length; ++i) {
                        this.createVO(organizations[i], parentid, themid);
                    }
                    if (applyTheme) {
                        Theme loggedinTheme = ThemeLocalServiceUtil.getTheme((long)OrganizationsUtil.getCompany().getCompanyId(), (String)themid, (boolean)false);
                        ThemeDisplay themeDisplay = (ThemeDisplay)this.getThreadLocalRequest().getSession().getAttribute("THEME_DISPLAY");
                        LayoutSetLocalServiceUtil.updateLookAndFeel((long)themeDisplay.getScopeGroupId(), (String)loggedinTheme.getThemeId(), (String)"", (String)"", (boolean)false);
                        _log.info((Object)("Loggedin Theme with id " + themid + " to Default Community Applied Correctly"));
                    }
                    break block12;
                }
                return false;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        LoginServiceUtil.appendRootOrganizationName((String)rootVoName);
        LoginServiceUtil.addPropertyDefaultLandingPageAndTheme((boolean)automaticRedirect, (SelectedTheme)theme);
        return true;
    }

    public Boolean isLayoutLoaded() {
        this.getASLSession();
        return new Boolean(false);
    }

    public void loadLayout(String scope, String URL2) {
        _log.trace((Object)"Calling Load Layout...");
        HttpSession session = this.getThreadLocalRequest().getSession();
        ASLSession mysession = SessionManager.getInstance().getASLSession(session.getId(), session.getAttribute("username").toString());
        mysession.setAttribute("loadlayout", (Object)"true");
        session.setAttribute("loadLayout", (Object)"true");
        session.setAttribute("selectedVRE", (Object)scope);
        mysession.logUserLogin(scope);
        mysession.setScope(scope);
        _log.trace((Object)("User login logged to: " + scope));
    }

    private void setVREBelonginApplication(VRE vre) {
        _log.info((Object)"AvailablePortlets stored in session");
        ArrayList<String> toSet = new ArrayList<String>();
        toSet.add("AnnotationFrontEnd_V2");
        this.getASLSession().setAttribute("availablePortlets", toSet);
    }

    public HashMap<String, ArrayList<CheckResult>> checkInfrastructure(String infrastructure, String startScopes) {
        HashMap<String, ArrayList<CheckResult>> toReturn = new HashMap<String, ArrayList<CheckResult>>();
        toReturn.put(infrastructure, LoginServiceUtil.checkScope((String)infrastructure));
        if (startScopes.contains(",")) {
            String[] organizations = startScopes.split(",");
            for (int i = 0; i < organizations.length; ++i) {
                toReturn.put(organizations[i], LoginServiceUtil.checkScope((String)(infrastructure + "/" + organizations[i])));
            }
        } else {
            String[] organizations = new String[]{startScopes};
            toReturn.put(organizations[0], LoginServiceUtil.checkScope((String)(infrastructure + "/" + organizations[0])));
        }
        _log.debug((Object)("Infra check result: " + toReturn));
        return toReturn;
    }

    public Boolean checkVresPresence(String infrastructure, String startScopes) {
        if (startScopes.contains(",")) {
            String[] organizations = startScopes.split(",");
            for (int i = 0; i < organizations.length; ++i) {
                if (!LoginServiceUtil.checkVresPresence((String)(infrastructure + "/" + organizations[i])).booleanValue()) continue;
                return true;
            }
            return false;
        }
        String[] organizations = new String[]{startScopes};
        return LoginServiceUtil.checkVresPresence((String)(infrastructure + "/" + organizations[0]));
    }

    public ArrayList<VO> getVresFromInfrastructure(String infrastructure, String startScopes) {
        ArrayList<VO> toReturn = new ArrayList<VO>();
        if (startScopes.contains(",")) {
            String[] organizations = startScopes.split(",");
            for (int i = 0; i < organizations.length; ++i) {
                VO toAdd = new VO();
                toAdd.setName(organizations[i]);
                toAdd.setVres(LoginServiceUtil.getVREsFromInfrastructure((String)(infrastructure + "/" + organizations[i])));
                toReturn.add(toAdd);
            }
        } else {
            String[] organizations = new String[]{startScopes};
            VO toAdd = new VO();
            toAdd.setName(organizations[0]);
            toAdd.setVres(LoginServiceUtil.getVREsFromInfrastructure((String)(infrastructure + "/" + organizations[0])));
            toReturn.add(toAdd);
        }
        return toReturn;
    }

    public Boolean installVREs(ArrayList<VO> parents) {
        for (VO vo : parents) {
            if (vo.getVres().size() <= 0) continue;
            long orgid = -1L;
            try {
                orgid = OrganizationLocalServiceUtil.getOrganization((long)OrganizationsUtil.getCompany().getCompanyId(), (String)vo.getName()).getOrganizationId();
                for (VRE vre : vo.getVres()) {
                    if (vre.getUserBelonging() == null) continue;
                    this.createVRE(vre.getName(), vre.getDescription(), orgid, this.SELECTED_THEMEID);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    public Boolean createAdministratorAccount(String email, String password, String firstname, String lastname) {
        User creator = null;
        try {
            ThemeDisplay themeDisplay = (ThemeDisplay)this.getThreadLocalRequest().getSession().getAttribute("THEME_DISPLAY");
            creator = themeDisplay.getUser();
            return LoginServiceUtil.createAdministratorAccountAndAssignRoles((long)creator.getUserId(), (String)email, (String)password, (String)firstname, (String)lastname);
        }
        catch (NoSuchRoleException ex) {
            _log.error((Object)("Error NoSuchRoleException userid for username " + creator.getScreenName() + " id: " + creator.getUserId()));
            ex.printStackTrace();
            return false;
        }
        catch (Exception e) {
            _log.error((Object)("Error while creating account administrator " + creator.getScreenName() + " id: " + creator.getUserId()));
            e.printStackTrace();
            return false;
        }
    }
}

