/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.gcubelogin.server.portlet;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.User;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletException;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.gcube.application.framework.core.session.SessionManager;

public class LoginPortlet
extends GenericPortlet {
    private static final String LIFERAY_USER_ID_KEY = "liferay.user.id";
    public static final int LIFERAY_COMMUNITY_ID = 2;
    protected String editJSP;
    protected String helpJSP;
    protected String viewJSP;
    private static Log _log = LogFactoryUtil.getLog(LoginPortlet.class);

    public void init() throws PortletException {
        this.editJSP = this.getInitParameter("edit-jsp");
        this.helpJSP = this.getInitParameter("help-jsp");
        this.viewJSP = this.getInitParameter("view-jsp");
    }

    public void doDispatch(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        String jspPage = renderRequest.getParameter("jspPage");
        if (jspPage != null) {
            this.include(jspPage, renderRequest, renderResponse);
        } else {
            super.doDispatch(renderRequest, renderResponse);
        }
    }

    public void doEdit(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        if (renderRequest.getPreferences() == null) {
            super.doEdit(renderRequest, renderResponse);
        } else {
            this.include(this.editJSP, renderRequest, renderResponse);
        }
    }

    public void doHelp(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        this.include(this.helpJSP, renderRequest, renderResponse);
    }

    public void doView(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        long userid = Long.parseLong(renderRequest.getRemoteUser());
        ThemeDisplay themeDisplay = (ThemeDisplay)renderRequest.getAttribute("THEME_DISPLAY");
        renderRequest.getPortletSession().setAttribute("THEME_DISPLAY", (Object)themeDisplay, 1);
        User user = null;
        try {
            user = UserLocalServiceUtil.getUser((long)userid);
            Group currentGroup = GroupLocalServiceUtil.getGroup((long)themeDisplay.getLayout().getGroup().getGroupId());
            if (currentGroup.getName().equalsIgnoreCase(this.getDefaultCommunityName())) {
                SessionManager.getInstance().getASLSession(renderRequest.getPortletSession().getId(), user.getScreenName()).invalidate();
            }
        }
        catch (SystemException e) {
            e.printStackTrace();
        }
        catch (PortalException e) {
            e.printStackTrace();
        }
        String username = user.getScreenName();
        renderRequest.getPortletSession().setAttribute("username", (Object)username, 1);
        renderRequest.getPortletSession().setAttribute("user", (Object)username, 1);
        this.include(this.viewJSP, renderRequest, renderResponse);
    }

    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) throws IOException, PortletException {
    }

    protected void include(String path, RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        PortletRequestDispatcher portletRequestDispatcher = this.getPortletContext().getRequestDispatcher(path);
        if (portletRequestDispatcher == null) {
            _log.error((Object)(path + " is not a valid include"));
        } else {
            portletRequestDispatcher.include(renderRequest, renderResponse);
        }
    }

    private String getDefaultCommunityName() throws PortalException, SystemException {
        Properties props = new Properties();
        String comName = "";
        try {
            String propertyfile = this.getPortletContext().getRealPath("") + "/config/resources.properties";
            File propsFile = new File(propertyfile);
            FileInputStream fis = new FileInputStream(propsFile);
            props.load(fis);
            comName = props.getProperty("defaultcommunity");
        }
        catch (IOException e) {
            _log.info((Object)"/config/resources.properties not found, Returning \"Data e-Infrastructure gateway\" as default Community");
        }
        String toReturn = comName;
        return toReturn;
    }
}

