/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.gcubelogin.client.wizard;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.gcube.portlets.user.gcubelogin.client.commons.LoadingPopUp;
import org.gcube.portlets.user.gcubelogin.client.stubs.NewLoginServiceAsync;
import org.gcube.portlets.user.gcubelogin.client.wizard.WizardUI;
import org.gcube.portlets.user.gcubelogin.shared.CheckResult;
import org.gcube.portlets.user.gcubelogin.shared.SelectedTheme;

/*
 * Exception performing whole class analysis ignored.
 */
public class WizardUI
extends Composite {
    private static WizardUIUiBinder uiBinder = (WizardUIUiBinder)GWT.create(WizardUIUiBinder.class);
    private boolean checkEnabled = true;
    private NewLoginServiceAsync newLoginSvc;
    private VerticalPanel mainPanel;
    @UiField
    Button checkButton;
    @UiField
    Button saveButton;
    @UiField
    Button loadButton;
    @UiField
    TextBox infraName;
    @UiField
    TextBox voNames;
    @UiField
    CheckBox autoRedirect;
    @UiField
    HTML testResult;
    @UiField
    HTML reportHtml;

    public WizardUI(NewLoginServiceAsync newLoginSvc, VerticalPanel mainPanel) {
        this.newLoginSvc = newLoginSvc;
        this.mainPanel = mainPanel;
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.autoRedirect.setValue(Boolean.valueOf(true));
        this.saveButton.setEnabled(false);
    }

    @UiHandler(value={"saveButton"})
    void onSaveClick(ClickEvent e) {
        if (Window.confirm((String)"The portal setup procedure is about to Start, if you're sure with the data you've entered press ok.")) {
            WizardUI.showLoading();
            SelectedTheme theme = SelectedTheme.GENERIC;
            this.newLoginSvc.installPortalEnv(this.infraName.getText(), this.voNames.getText(), theme, this.autoRedirect.getValue().booleanValue(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    @UiHandler(value={"loadButton"})
    void onLoadClick(ClickEvent e) {
        WizardUI.showLoading();
        this.newLoginSvc.getInfrastructureConfig((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    @UiHandler(value={"checkButton"})
    void onCheckClick(ClickEvent e) {
        if (!this.checkEnabled) {
            this.saveButton.setEnabled(false);
            this.infraName.setReadOnly(false);
            this.voNames.setReadOnly(false);
            this.checkEnabled = true;
            this.testResult.setText("you can't run the install until we checked your configuration");
            this.checkButton.setText("Check again");
        } else {
            this.removeBlanks(this.infraName);
            this.removeBlanks(this.voNames);
            if (this.infraName.getText().equals("") || this.voNames.getText().equals("")) {
                Window.alert((String)"Infrastructure and Starting scopes are required");
            } else {
                this.reportHtml.setText("");
                this.showSpinner();
                this.newLoginSvc.checkInfrastructure(this.infraName.getText(), this.voNames.getText(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
            }
        }
    }

    static void showLoading() {
        LoadingPopUp dlg = LoadingPopUp.get();
        dlg.show();
    }

    static void hideLoading() {
        LoadingPopUp dlg = LoadingPopUp.get();
        dlg.hide();
    }

    private void removeBlanks(TextBox tb) {
        tb.setText(tb.getText().replaceAll(" ", ""));
    }

    private void showSpinner() {
        this.testResult.setText("");
        this.testResult.setSize("350px", "20px");
        this.testResult.addStyleName("spinner");
    }

    private void hideSpinner() {
        this.testResult.removeStyleName("spinner");
    }

    private String getShowResult(HashMap<String, ArrayList<CheckResult>> result) {
        String html = "<table>";
        for (Map.Entry<String, ArrayList<CheckResult>> scope : result.entrySet()) {
            html = html + "<tr>";
            html = html + "<td><strong>" + scope.getKey() + ":</strong></td>";
            for (CheckResult res : scope.getValue()) {
                if (res.isPassed()) {
                    html = html + "<td><nobr><span style=\"color:green;\">" + res.getType() + ": " + res.isPassed() + " </span></nobr></td>";
                    continue;
                }
                html = html + "<td><nobr><span style=\"color:red;\">" + res.getType() + ": " + res.isPassed() + " </span></nobr></td>";
            }
            html = html + "</tr>";
        }
        html = html + "</table>";
        this.reportHtml.setHTML(html);
        return html;
    }

    private boolean getTestResult(HashMap<String, ArrayList<CheckResult>> result) {
        for (Map.Entry<String, ArrayList<CheckResult>> scope : result.entrySet()) {
            for (CheckResult res : scope.getValue()) {
                if (res.isPassed()) continue;
                return false;
            }
        }
        return true;
    }

    static /* synthetic */ VerticalPanel access$000(WizardUI x0) {
        return x0.mainPanel;
    }

    static /* synthetic */ NewLoginServiceAsync access$100(WizardUI x0) {
        return x0.newLoginSvc;
    }

    static /* synthetic */ void access$200(WizardUI x0) {
        x0.hideSpinner();
    }

    static /* synthetic */ boolean access$300(WizardUI x0, HashMap x1) {
        return x0.getTestResult(x1);
    }

    static /* synthetic */ boolean access$402(WizardUI x0, boolean x1) {
        x0.checkEnabled = x1;
        return x0.checkEnabled;
    }

    static /* synthetic */ String access$500(WizardUI x0, HashMap x1) {
        return x0.getShowResult(x1);
    }
}

