/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.resourcemanager.impl.state.observers;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.QNameMap;
import com.thoughtworks.xstream.io.xml.StaxDriver;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.xml.namespace.QName;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.vremanagement.resourcemanager.impl.contexts.ServiceContext;
import org.gcube.vremanagement.resourcemanager.impl.resources.ScopedAnyResource;
import org.gcube.vremanagement.resourcemanager.impl.resources.ScopedDeployedSoftware;
import org.gcube.vremanagement.resourcemanager.impl.resources.ScopedGHN;
import org.gcube.vremanagement.resourcemanager.impl.resources.ScopedResource;
import org.gcube.vremanagement.resourcemanager.impl.resources.ScopedRunningInstance;
import org.gcube.vremanagement.resourcemanager.impl.resources.types.MultiKeysMap;
import org.gcube.vremanagement.resourcemanager.impl.state.RawScopeState;
import org.gcube.vremanagement.resourcemanager.impl.state.ScopeState;
import org.gcube.vremanagement.resourcemanager.impl.state.VirtualNode;
import org.gcube.vremanagement.resourcemanager.impl.state.observers.ScopeObserver;

public class Serializer
extends ScopeObserver {
    private static final String namespace = "http://gcube-system.org/namespaces/resourcemanager/manager/xsd/state";

    @Override
    protected synchronized void scopeChanged(ScopeState scopeState) {
        try {
            if (!scopeState.isDisposed()) {
                this.logger.debug((Object)"Serializer: the scopeState is changed. need store the change ");
                Serializer.store(scopeState);
            } else {
                this.logger.debug((Object)"Serralizer: the scopeState is disposed doesn't need to serialize it");
            }
        }
        catch (IOException e) {
            this.logger.fatal((Object)"Cannot serialize the resource's list", (Throwable)e);
        }
    }

    public static synchronized void store(ScopeState scopeState) throws IOException {
        QNameMap qmap = new QNameMap();
        qmap.registerMapping(new QName(namespace, ""), RawScopeState.class);
        StaxDriver driver = new StaxDriver(qmap);
        driver.setRepairingNamespace(false);
        XStream stream = new XStream((HierarchicalStreamDriver)driver);
        Serializer.prepareStream(stream);
        FileOutputStream fs = new FileOutputStream(Serializer.getSerializationFile(scopeState.getScope()));
        stream.toXML((Object)scopeState.getRawScopeState(), (OutputStream)fs);
        fs.close();
    }

    public static synchronized void load(ScopeState scopeState, GCUBEScope scope) throws IOException {
        File persistentFile = Serializer.getSerializationFile(scope);
        if (!persistentFile.exists() && !(persistentFile = ServiceContext.getContext().getPersistentFile("ScopedResourceList.xml", new boolean[]{true})).exists()) {
            throw new IOException();
        }
        QNameMap qmap = new QNameMap();
        qmap.registerMapping(new QName(namespace, ""), RawScopeState.class);
        StaxDriver driver = new StaxDriver(qmap);
        driver.setRepairingNamespace(false);
        XStream stream = new XStream((HierarchicalStreamDriver)driver);
        Serializer.prepareStream(stream);
        FileInputStream fis = new FileInputStream(persistentFile);
        RawScopeState state = (RawScopeState)stream.fromXML((InputStream)fis);
        fis.close();
        if (state == null || state.getScope() == null || state.getScope().getName().compareTo(scope.getName()) != 0) {
            throw new IOException();
        }
        scopeState.setRawScopeState(state);
    }

    private static void prepareStream(XStream stream) {
        stream.processAnnotations(RawScopeState.class);
        stream.alias(RawScopeState.class.getSimpleName(), RawScopeState.class);
        stream.processAnnotations(ScopedResource.class);
        stream.alias(ScopedResource.class.getSimpleName(), ScopedResource.class);
        stream.alias(ScopedGHN.class.getSimpleName(), ScopedGHN.class);
        stream.processAnnotations(ScopedGHN.class);
        stream.alias(ScopedRunningInstance.class.getSimpleName(), ScopedRunningInstance.class);
        stream.processAnnotations(ScopedRunningInstance.class);
        stream.alias(ScopedDeployedSoftware.class.getSimpleName(), ScopedDeployedSoftware.class);
        stream.processAnnotations(ScopedDeployedSoftware.class);
        stream.alias(ScopedAnyResource.class.getSimpleName(), ScopedAnyResource.class);
        stream.processAnnotations(ScopedAnyResource.class);
        stream.alias("ResourceList", MultiKeysMap.class);
        stream.alias("ResourceData", Map.class);
        stream.alias("Scope", GCUBEScope.class);
        stream.alias("ScopeType", GCUBEScope.Type.class);
        stream.alias("VirtualNode", VirtualNode.class);
    }

    protected static File getSerializationFile(GCUBEScope scope) {
        return ServiceContext.getContext().getPersistentFile("SerializedResourceList" + scope.toString().replace('/', '-'), new boolean[]{true});
    }
}

