/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.search.datafusion.datatypes;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.gcube.search.datafusion.datatypes.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RankedRecord
implements Comparable<RankedRecord>,
Serializable {
    private static final long serialVersionUID = 1L;
    private String id;
    private Long position;
    private Float rank;
    private Integer luceneDocID;
    private Boolean includePosition = false;
    private static final Logger LOGGER = LoggerFactory.getLogger(RankedRecord.class);

    public RankedRecord(String id, Long position, Float rank, Integer luceneDocID, Boolean includePosition) {
        this.id = id;
        this.position = position;
        this.rank = rank;
        this.luceneDocID = luceneDocID;
        this.includePosition = includePosition;
    }

    public RankedRecord(String id, Long position, Float rank, Integer luceneDocID) {
        this(id, position, rank, luceneDocID, Boolean.FALSE);
    }

    public String toString() {
        return "RankedRecord [id=" + this.id + ", position=" + this.position + ", rank=" + this.rank + ", luceneDocID=" + this.getLuceneDocID() + " calculated score=" + RankedRecord.calcScore(this) + "]";
    }

    public Integer getLuceneDocID() {
        return this.luceneDocID;
    }

    @Override
    public int compareTo(RankedRecord r) {
        Float pos_score1 = RankedRecord.calcScore(this);
        Float pos_score2 = RankedRecord.calcScore(r);
        if (pos_score1.floatValue() < pos_score2.floatValue()) {
            return 1;
        }
        if (pos_score1.floatValue() > pos_score2.floatValue()) {
            return -1;
        }
        return 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.includePosition == null ? 0 : this.includePosition.hashCode());
        result = 31 * result + (this.luceneDocID == null ? 0 : this.luceneDocID.hashCode());
        result = 31 * result + (this.position == null ? 0 : this.position.hashCode());
        result = 31 * result + (this.rank == null ? 0 : this.rank.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RankedRecord other = (RankedRecord)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.includePosition == null ? other.includePosition != null : !this.includePosition.equals(other.includePosition)) {
            return false;
        }
        if (this.luceneDocID == null ? other.luceneDocID != null : !this.luceneDocID.equals(other.luceneDocID)) {
            return false;
        }
        if (this.position == null ? other.position != null : !this.position.equals(other.position)) {
            return false;
        }
        return !(this.rank == null ? other.rank != null : !this.rank.equals(other.rank));
    }

    public static Float calcScore(RankedRecord r) {
        if (!r.includePosition.booleanValue()) {
            return r.rank;
        }
        Float posScore = RankedRecord.positionScore(r);
        Float totalScore = null;
        totalScore = r.rank == null ? posScore : Float.valueOf(posScore.floatValue() + r.rank.floatValue());
        return totalScore;
    }

    private static Float positionScore(RankedRecord r) {
        double a = 0.9860852999637;
        double b = 1.025038425038;
        Float pos_score = Float.valueOf((float)(a / Math.pow(b, r.position.longValue())));
        return pos_score;
    }

    public static List<RankedRecord> recalculateScores(Map<String, Long> recPositions, Map<String, Pair> recScores, Boolean includePosition) {
        ArrayList<RankedRecord> recs = new ArrayList<RankedRecord>();
        for (Map.Entry<String, Long> recPos : recPositions.entrySet()) {
            String docID = recPos.getKey();
            Long pos = recPos.getValue();
            Float score = null;
            Integer luceneDocumentID = null;
            Pair p = recScores.get(docID);
            if (p == null) {
                LOGGER.error("Document with id " + docID + " was not returned by lucene query. Returned hits are : " + recScores);
                continue;
            }
            score = p.getScore();
            luceneDocumentID = p.getLuceneDocID();
            RankedRecord rr = new RankedRecord(docID, pos, score, luceneDocumentID, includePosition);
            recs.add(rr);
        }
        Collections.sort(recs);
        return recs;
    }
}

