/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.io.jsonwebtoken.impl.security;

import java.security.Key;
import java.util.Set;
import org.gcube.io.jsonwebtoken.impl.lang.Parameter;
import org.gcube.io.jsonwebtoken.impl.lang.ParameterReadable;
import org.gcube.io.jsonwebtoken.impl.security.AbstractFamilyJwkFactory;
import org.gcube.io.jsonwebtoken.impl.security.DefaultOctetPublicJwk;
import org.gcube.io.jsonwebtoken.impl.security.EdwardsCurve;
import org.gcube.io.jsonwebtoken.security.Jwk;
import org.gcube.io.jsonwebtoken.security.UnsupportedKeyException;

public abstract class OctetJwkFactory<K extends Key, J extends Jwk<K>>
extends AbstractFamilyJwkFactory<K, J> {
    OctetJwkFactory(Class<K> keyType, Set<Parameter<?>> params) {
        super("OKP", keyType, params);
    }

    @Override
    public boolean supports(Key key) {
        return super.supports(key) && EdwardsCurve.isEdwards(key);
    }

    protected static EdwardsCurve getCurve(ParameterReadable reader) throws UnsupportedKeyException {
        Parameter<String> param = DefaultOctetPublicJwk.CRV;
        String crvId = reader.get(param);
        EdwardsCurve curve = EdwardsCurve.findById(crvId);
        if (curve == null) {
            String msg = "Unrecognized OKP JWK " + param + " value '" + crvId + "'";
            throw new UnsupportedKeyException(msg);
        }
        return curve;
    }
}

