/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.publisher.impl.model;

import org.apache.commons.io.FilenameUtils;
import org.gcube.application.aquamaps.publisher.impl.PublisherImpl;
import org.gcube.application.aquamaps.publisher.impl.model.FileType;
import org.gcube.common.core.utils.logging.GCUBELog;

public class File {
    private static transient GCUBELog logger = new GCUBELog(File.class);
    private FileType type = FileType.InternalProfile;
    private String originalUri;
    private String storedUri = null;
    private String name;

    public String toString() {
        return "File [type=" + (Object)((Object)this.type) + ", uuri=" + this.originalUri + ", name=" + this.name + "]";
    }

    public File(FileType type, String originalUri, String name) {
        this.type = type;
        this.originalUri = originalUri;
        this.name = name;
    }

    public FileType getType() {
        return this.type;
    }

    public void setType(FileType type) {
        this.type = type;
    }

    public String getOriginalUri() {
        return this.originalUri;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getStoredUri() {
        return this.storedUri;
    }

    protected void publish(String baseDir, boolean deleteIfExists) throws Exception {
        java.io.File file = new java.io.File(this.originalUri);
        String ext = "." + FilenameUtils.getExtension((String)file.getAbsolutePath());
        java.io.File renameFile = new java.io.File(PublisherImpl.serverPathDir + java.io.File.separator + baseDir, this.name.replace(" ", "_").replace(":", "") + ext);
        if (deleteIfExists && renameFile.exists()) {
            renameFile.delete();
        }
        logger.trace((Object)(" the file " + file.getAbsolutePath() + " exists? " + file.exists()));
        logger.trace((Object)(" the file " + file.getAbsolutePath() + " is readable? " + file.canRead()));
        logger.trace((Object)(" the file " + file.getAbsolutePath() + " is writable? " + file.canWrite()));
        logger.trace((Object)(" the file to rename  " + renameFile.getAbsolutePath() + " exists? " + renameFile.exists()));
        if (!file.renameTo(renameFile)) {
            throw new Exception("the file " + this.name + " has not been published");
        }
        this.storedUri = baseDir + java.io.File.separator + this.name.replace(" ", "_").replace(":", "") + ext;
        this.originalUri = null;
    }

    protected void unpublish() throws Exception {
        java.io.File file = new java.io.File(PublisherImpl.serverPathDir + java.io.File.separator + this.storedUri);
        if (!file.delete()) {
            throw new Exception("the file " + this.name + " has not been unpublished");
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.originalUri == null ? 0 : this.originalUri.hashCode());
        result = 31 * result + (this.storedUri == null ? 0 : this.storedUri.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        File other = (File)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.originalUri == null ? other.originalUri != null : !this.originalUri.equals(other.originalUri)) {
            return false;
        }
        if (this.storedUri == null ? other.storedUri != null : !this.storedUri.equals(other.storedUri)) {
            return false;
        }
        return this.type == other.type;
    }
}

