/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsservice.impl.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.DBSession;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Field;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.fields.HSPECFields;
import org.gcube_system.namespaces.application.aquamaps.types.OrderDirection;

public class MySQLDBSession
extends DBSession {
    public MySQLDBSession(Connection conn) {
        super(conn);
    }

    @Override
    public ResultSet executeFilteredQuery(List<Field> filters, String table, String orderColumn, OrderDirection orderMode) throws Exception {
        PreparedStatement ps = this.getPreparedStatementForQuery(filters, table, orderColumn, orderMode);
        return this.fillParameters(filters, 0, ps).executeQuery();
    }

    @Override
    public PreparedStatement fillParameters(List<Field> fields, int parameterOffset, PreparedStatement ps) throws SQLException {
        block12: for (int i = 0; i < fields.size(); ++i) {
            Field f = fields.get(i);
            switch (f.getType()) {
                case BOOLEAN: {
                    Integer value = f.getValueAsBoolean(DEFAULT_BOOLEAN_VALUE) != false ? 1 : 0;
                    ps.setInt(i + 1 + parameterOffset, value);
                    continue block12;
                }
                case DOUBLE: {
                    ps.setDouble(i + 1 + parameterOffset, f.getValueAsDouble(DEFAULT_DOUBLE_VALUE));
                    continue block12;
                }
                case INTEGER: {
                    try {
                        ps.setInt(i + 1 + parameterOffset, f.getValueAsInteger(DEFAULT_INTEGER_VALUE));
                    }
                    catch (NumberFormatException e) {
                        ps.setLong(i + 1 + parameterOffset, Long.parseLong(f.getValue()));
                    }
                    continue block12;
                }
                case TIMESTAMP: {
                    try {
                        ps.setTimestamp(i + 1 + parameterOffset, Timestamp.valueOf(f.getValue()));
                    }
                    catch (IllegalArgumentException e) {
                        ps.setNull(i + 1 + parameterOffset, 93);
                    }
                    continue block12;
                }
                case STRING: {
                    ps.setString(i + 1 + parameterOffset, f.getValue());
                    continue block12;
                }
                case LONG: {
                    ps.setLong(i + 1 + parameterOffset, f.getValueAsLong(DEFAULT_LONG_VALUE));
                }
            }
        }
        return ps;
    }

    @Override
    public boolean checkExist(String tableName, List<Field> keys) throws Exception {
        PreparedStatement ps = this.getPreparedStatementForQuery(keys, tableName, null, null);
        ResultSet rs = this.fillParameters(keys, 0, ps).executeQuery();
        return rs.first();
    }

    @Override
    public int deleteOperation(String tableName, List<Field> filters) throws Exception {
        PreparedStatement ps = this.getPreparedStatementForDelete(filters, tableName);
        return this.fillParameters(filters, 0, ps).executeUpdate();
    }

    @Override
    public Long getCount(String tableName, List<Field> filters) throws Exception {
        PreparedStatement ps = this.getPreparedStatementForCount(filters, tableName);
        ResultSet rs = this.fillParameters(filters, 0, ps).executeQuery();
        if (rs.next()) {
            return rs.getLong(1);
        }
        return 0L;
    }

    @Override
    public PreparedStatement getFilterCellByAreaQuery(HSPECFields filterByCodeType, String sourceTableName, String destinationTableName) throws Exception {
        switch (filterByCodeType) {
            case faoaream: {
                return this.preparedStatement("INSERT IGNORE INTO " + destinationTableName + " ( Select " + sourceTableName + ".* from " + sourceTableName + " where " + sourceTableName + "." + HSPECFields.faoaream + " = ? ) ");
            }
            case eezall: {
                return this.preparedStatement("INSERT IGNORE INTO " + destinationTableName + " ( Select " + sourceTableName + ".* from " + sourceTableName + " where find_in_set( ? , " + sourceTableName + "." + HSPECFields.eezall + ")) ");
            }
            case lme: {
                return this.preparedStatement("INSERT IGNORE INTO " + destinationTableName + " ( Select " + sourceTableName + ".* from " + sourceTableName + " where " + sourceTableName + "." + HSPECFields.lme + " = ? ) ");
            }
        }
        throw new SQLException("Invalid Field " + filterByCodeType);
    }

    @Override
    public List<List<Field>> insertOperation(String tableName, List<List<Field>> rows) throws Exception {
        ArrayList<List<Field>> toReturn = new ArrayList<List<Field>>();
        if (rows.size() == 0) {
            throw new Exception("Empty rows to insert");
        }
        PreparedStatement ps = this.getPreparedStatementForInsert(rows.get(0), tableName);
        for (List<Field> row : rows) {
            ps = this.fillParameters(row, 0, ps);
            if (ps.executeUpdate() <= 0) continue;
            toReturn.addAll(this.getGeneratedKeys(ps));
        }
        return toReturn;
    }

    @Override
    public int updateOperation(String tableName, List<List<Field>> keys, List<List<Field>> rows) throws Exception {
        int count = 0;
        if (rows.size() == 0) {
            throw new Exception("Empty rows to insert");
        }
        if (keys.size() == 0) {
            throw new Exception("Empty keys");
        }
        if (rows.size() != keys.size()) {
            throw new Exception("Un matching rows/keys sizes " + rows.size() + "/" + keys.size());
        }
        PreparedStatement ps = this.getPreparedStatementForUpdate(rows.get(0), keys.get(0), tableName);
        for (int i = 0; i < rows.size(); ++i) {
            ps = this.fillParameters(rows.get(i), 0, ps);
            ps = this.fillParameters(keys.get(i), rows.get(i).size(), ps);
            count += ps.executeUpdate();
        }
        return count;
    }

    public void createTable(String tableName, String[] columnsAndConstraintDefinition, int numParitions, String partitioningKey, DBSession.ENGINE ... engines) throws Exception {
        Statement statement = this.connection.createStatement();
        String engine = engines.length == 0 ? "" : "ENGINE=" + engines[0].toString();
        StringBuilder createQuery = new StringBuilder("CREATE TABLE IF NOT EXISTS " + tableName + " (");
        for (String singleColumnDef : columnsAndConstraintDefinition) {
            createQuery.append(singleColumnDef + ",");
        }
        createQuery.deleteCharAt(createQuery.length() - 1);
        createQuery.append(") " + engine + " CHARACTER SET utf8 COLLATE utf8_general_ci  PARTITION BY KEY(" + partitioningKey + ") PARTITIONS " + numParitions + " ;");
        logger.debug((Object)("the query is: " + createQuery.toString()));
        statement.executeUpdate(createQuery.toString());
        statement.close();
    }

    @Override
    public void createLikeTable(String newTableName, String oldTable) throws Exception {
        Statement statement = this.connection.createStatement();
        statement.executeUpdate("CREATE TABLE IF NOT EXISTS " + newTableName + " LIKE " + oldTable);
        logger.debug((Object)("the like creation is : CREATE TABLE IF NOT EXISTS " + newTableName + " LIKE " + oldTable));
        statement.close();
    }

    @Override
    public void createTable(String tableName, String[] columnsAndConstraintDefinition) throws Exception {
        Statement statement = this.connection.createStatement();
        StringBuilder createQuery = new StringBuilder("CREATE TABLE IF NOT EXISTS " + tableName + " (");
        for (String singleColumnDef : columnsAndConstraintDefinition) {
            createQuery.append(singleColumnDef + ",");
        }
        createQuery.deleteCharAt(createQuery.length() - 1);
        createQuery.append(") CHARACTER SET utf8 COLLATE utf8_general_ci ;");
        logger.debug((Object)("the query is: " + createQuery.toString()));
        statement.executeUpdate(createQuery.toString());
        statement.close();
    }

    @Override
    public PreparedStatement getPreparedStatementForInsertOnDuplicate(List<Field> fields, String table, Integer[] keyIndexes) throws Exception {
        throw new Exception("YET TO IMPLEMENT");
    }

    @Override
    public ResultSet getDistinct(Field toSelect, List<Field> filters, String table, String orderColumn, OrderDirection orderMode) throws Exception {
        PreparedStatement ps = this.getPreparedStatementForDISTINCT(filters, toSelect, table, orderColumn, orderMode);
        return this.fillParameters(filters, 0, ps).executeQuery();
    }

    @Override
    public String exportTableToCSV(String tableName, boolean hasHeaders, char delimiter) throws Exception {
        throw new Exception("NOt Implemented for this DB type");
    }
}

