/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsservice.impl.engine.maps;

import org.gcube.application.aquamaps.aquamapsservice.impl.ServiceContext;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.managers.SubmittedManager;
import org.gcube.application.aquamaps.aquamapsservice.impl.engine.maps.JobExecutionManager;
import org.gcube.application.aquamaps.aquamapsservice.impl.publishing.AquaMapsObjectExecutionRequest;
import org.gcube.application.aquamaps.aquamapsservice.impl.publishing.Generator;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.SubmittedStatus;
import org.gcube.application.aquamaps.publisher.Publisher;
import org.gcube.application.aquamaps.publisher.StoreConfiguration;
import org.gcube.application.aquamaps.publisher.UpdateConfiguration;
import org.gcube.application.aquamaps.publisher.impl.model.CoverageDescriptor;
import org.gcube.application.aquamaps.publisher.impl.model.FileSet;
import org.gcube.application.aquamaps.publisher.impl.model.Layer;
import org.gcube.common.core.utils.logging.GCUBELog;

public class AquaMapsObjectWorker
extends Thread {
    private static final GCUBELog logger = new GCUBELog(AquaMapsObjectWorker.class);
    private AquaMapsObjectExecutionRequest request;

    public AquaMapsObjectWorker(AquaMapsObjectExecutionRequest requestSettings) {
        this.request = requestSettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            logger.debug((Object)("Started OBJECT " + this.request.getObject().getSearchId() + "Execution"));
            SubmittedManager.setStartTime(this.request.getObject().getSearchId());
            this.request.setObject(SubmittedManager.getSubmittedById(this.request.getObject().getSearchId()));
            Publisher publisher = ServiceContext.getContext().getPublisher();
            CoverageDescriptor descriptor = new CoverageDescriptor(this.request.getObject().getSourceHSPEC() + "", this.request.getObject().getSpeciesCoverage());
            String fileSetID = null;
            String layerID = null;
            Generator<FileSet> fileSetGenerator = new Generator<FileSet>(this.request, FileSet.class);
            Generator<Layer> layerGenrator = new Generator<Layer>(this.request, Layer.class);
            if (this.request.getObject().getIsCustomized().booleanValue() || this.request.getObject().isForceRegeneration().booleanValue()) {
                descriptor.setCustomized(this.request.getObject().getIsCustomized().booleanValue());
                fileSetID = ((FileSet)publisher.store(FileSet.class, fileSetGenerator, new StoreConfiguration(StoreConfiguration.StoreMode.UPDATE_EXISTING, new UpdateConfiguration(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true))), new CoverageDescriptor[]{descriptor}).getStoredId()).getId();
                if (this.request.getObject().getGisEnabled().booleanValue()) {
                    layerID = ((Layer)publisher.store(Layer.class, layerGenrator, new StoreConfiguration(StoreConfiguration.StoreMode.UPDATE_EXISTING, new UpdateConfiguration(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true))), new CoverageDescriptor[]{descriptor}).getStoredId()).getId();
                }
            } else {
                fileSetID = ((FileSet)publisher.get(FileSet.class, fileSetGenerator, descriptor).get()).getId();
                if (this.request.getObject().getGisEnabled().booleanValue()) {
                    layerID = ((Layer)publisher.get(Layer.class, layerGenrator, descriptor).get()).getId();
                }
            }
            this.request.getObject().setFileSetId(fileSetID);
            this.request.getObject().setGisPublishedId(layerID);
            SubmittedManager.update(this.request.getObject());
            SubmittedManager.updateStatus(this.request.getObject().getSearchId(), SubmittedStatus.Completed);
        }
        catch (Exception e) {
            logger.error((Object)("Failed Object execution " + this.request.getObject().getSearchId()), (Throwable)e);
            try {
                SubmittedManager.updateStatus(this.request.getObject().getSearchId(), SubmittedStatus.Error);
            }
            catch (Exception e1) {
                logger.fatal((Object)"Unexpected Error ", (Throwable)e1);
            }
        }
        finally {
            JobExecutionManager.alertJob(this.request.getObject().getSearchId(), this.request.getObject().getJobId());
            JobExecutionManager.cleanReferences(this.request.getObject());
        }
    }
}

