/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsservice.impl.engine.predictions;

import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.gcube.application.aquamaps.aquamapsservice.impl.ServiceContext;
import org.gcube.application.aquamaps.aquamapsservice.impl.engine.predictions.BatchGeneratorI;
import org.gcube.application.aquamaps.aquamapsservice.impl.engine.predictions.BatchGeneratorObjectFactory;
import org.gcube.common.core.utils.logging.GCUBELog;

public class EnvironmentalLogicManager {
    static GCUBELog logger;
    private static GenericObjectPool batchPool;
    private static GenericObjectPool remotePool;

    public static BatchGeneratorI getBatch(String submissionBackend) throws Exception {
        if (submissionBackend.equalsIgnoreCase(ServiceContext.getContext().getName())) {
            return (BatchGeneratorI)batchPool.borrowObject();
        }
        return (BatchGeneratorI)remotePool.borrowObject();
    }

    public static void leaveBatch(BatchGeneratorI theBatch) throws Exception {
        switch (theBatch.getType()) {
            case LOCAL: {
                batchPool.returnObject((Object)theBatch);
                break;
            }
            default: {
                remotePool.returnObject((Object)theBatch);
            }
        }
    }

    static {
        int i;
        logger = new GCUBELog(EnvironmentalLogicManager.class);
        batchPool = new GenericObjectPool((PoolableObjectFactory)new BatchGeneratorObjectFactory(BatchGeneratorObjectFactory.BatchPoolType.LOCAL));
        remotePool = new GenericObjectPool((PoolableObjectFactory)new BatchGeneratorObjectFactory(BatchGeneratorObjectFactory.BatchPoolType.REMOTE));
        try {
            batchPool.setLifo(false);
            batchPool.setMaxActive(ServiceContext.getContext().getPropertyAsInteger("LOCAL_BATCH_POOL_SIZE").intValue());
            batchPool.setWhenExhaustedAction((byte)1);
            for (i = 0; i < batchPool.getMaxActive(); ++i) {
                batchPool.addObject();
            }
            logger.debug((Object)("Added " + batchPool.getMaxActive() + " objects to local generator pool"));
        }
        catch (Exception e) {
            logger.error((Object)"Unable to init batch pool", (Throwable)e);
        }
        try {
            remotePool.setLifo(false);
            remotePool.setMaxActive(ServiceContext.getContext().getPropertyAsInteger("REMOTE_BATCH_POOL_SIZE").intValue());
            remotePool.setWhenExhaustedAction((byte)1);
            for (i = 0; i < remotePool.getMaxActive(); ++i) {
                remotePool.addObject();
            }
            logger.debug((Object)("Added " + remotePool.getMaxActive() + " objects to remote generator pool"));
        }
        catch (Exception e) {
            logger.error((Object)"Unable to init remote pool", (Throwable)e);
        }
    }
}

