/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsservice.impl;

import gr.uoa.di.madgik.commons.utils.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.Writer;
import java.net.URI;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.gcube.application.aquamaps.aquamapsservice.impl.CommonServiceLogic;
import org.gcube.application.aquamaps.aquamapsservice.impl.ServiceContext;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.managers.AnalysisTableManager;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.managers.CustomQueryManager;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.managers.ExportManager;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.managers.SourceGenerationRequestsManager;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.managers.SourceManager;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.managers.SubmittedManager;
import org.gcube.application.aquamaps.aquamapsservice.impl.engine.analysis.AnalysisManager;
import org.gcube.application.aquamaps.aquamapsservice.impl.engine.predictions.BatchGeneratorObjectFactory;
import org.gcube.application.aquamaps.aquamapsservice.impl.engine.tables.TableGenerationExecutionManager;
import org.gcube.application.aquamaps.aquamapsservice.impl.util.ServiceUtils;
import org.gcube.application.aquamaps.aquamapsservice.stubs.CustomQueryDescriptorStubs;
import org.gcube.application.aquamaps.aquamapsservice.stubs.DataManagementPortType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.ExportTableRequestType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.ExportTableStatusType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.GenerateMapsRequestType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.GetGenerationLiveReportResponseType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.HspecGroupGenerationRequestType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.ImportResourceRequestType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.RemoveHSPECGroupGenerationRequestResponseType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.SetUserCustomQueryRequestType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.ViewCustomQueryRequestType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Field;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Submitted;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.environments.EnvironmentalExecutionReportItem;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.environments.SourceGenerationRequest;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.fields.SourceGenerationRequestFields;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.fields.SubmittedFields;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.FieldType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.LogicType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.ResourceType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.SourceGenerationPhase;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.SubmittedStatus;
import org.gcube.application.aquamaps.aquamapsservice.stubs.wrapper.utils.RSWrapper;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.porttypes.GCUBEPortType;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.types.StringArray;
import org.gcube.common.core.types.VOID;
import org.gcube.dataanalysis.ecoengine.utils.ResourceFactory;
import org.gcube_system.namespaces.application.aquamaps.types.Analysis;
import org.gcube_system.namespaces.application.aquamaps.types.FieldArray;
import org.gcube_system.namespaces.application.aquamaps.types.OrderDirection;
import org.gcube_system.namespaces.application.aquamaps.types.PagedRequestSettings;
import org.gcube_system.namespaces.application.aquamaps.types.Resource;

public class DataManagement
extends GCUBEPortType
implements DataManagementPortType {
    protected GCUBEServiceContext getServiceContext() {
        return ServiceContext.getContext();
    }

    public int generateMaps(GenerateMapsRequestType arg0) throws RemoteException, GCUBEFault {
        try {
            return CommonServiceLogic.generateMaps_Logic(arg0.getHSPECId(), Field.load((FieldArray)arg0.getSpeciesFilter()), arg0.getAuthor(), arg0.isGenerateLayers(), arg0.isForceRegeneration());
        }
        catch (Exception e) {
            this.logger.error((Object)"Unable to execute request ", (Throwable)e);
            throw new GCUBEFault(new String[]{"ServerSide msg: " + e.getMessage()});
        }
    }

    public String generateHSPECGroup(HspecGroupGenerationRequestType arg0) throws RemoteException, GCUBEFault {
        try {
            org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Resource r;
            long availableSpace = GHNContext.getContext().getFreeSpace(GHNContext.getContext().getLocation());
            long threshold = ServiceContext.getContext().getPropertyAsInteger("MONITOR_FREESPACE_THRESHOLD").intValue();
            if (availableSpace < threshold) {
                throw new Exception("NOT ENOUGH SPACE, REMAINING : " + availableSpace + ", THRESHOLD : " + threshold);
            }
            this.logger.trace((Object)("Received hspec group generation request, title : " + arg0.getGenerationName()));
            SourceGenerationRequest request = new SourceGenerationRequest(arg0);
            for (Integer resId : request.getHcafIds()) {
                r = SourceManager.getById(resId);
                if (r != null && r.getType().equals((Object)ResourceType.HCAF)) continue;
                throw new Exception("Invalid HCAF id " + resId);
            }
            for (Integer resId : request.getHspenIds()) {
                r = SourceManager.getById(resId);
                if (r != null && r.getType().equals((Object)ResourceType.HSPEN)) continue;
                throw new Exception("Invalid HSPEN id " + resId);
            }
            for (Integer resId : request.getOccurrenceCellIds()) {
                r = SourceManager.getById(resId);
                if (r != null && r.getType().equals((Object)ResourceType.OCCURRENCECELLS)) continue;
                throw new Exception("Invalid Occurrence Cells id " + resId);
            }
            return TableGenerationExecutionManager.insertRequest(request);
        }
        catch (Exception e) {
            this.logger.error((Object)"Unable to execute request ", (Throwable)e);
            throw new GCUBEFault(new String[]{"ServerSide msg: " + e.getMessage()});
        }
    }

    public String getJSONSubmittedHSPECGroup(PagedRequestSettings arg0) throws RemoteException, GCUBEFault {
        try {
            return SourceGenerationRequestsManager.getJSONList(new ArrayList<Field>(), arg0);
        }
        catch (Exception e) {
            this.logger.error((Object)"Unable to execute request ", (Throwable)e);
            throw new GCUBEFault(new String[]{"ServerSide msg: " + e.getMessage()});
        }
    }

    public GetGenerationLiveReportResponseType getGenerationLiveReportGroup(StringArray ids) throws RemoteException, GCUBEFault {
        try {
            if (ids == null || ids.getItems() == null || ids.getItems().length == 0) {
                throw new Exception("INVALID REQUEST : No Report ID specified");
            }
            ArrayList<String> mapLoad = new ArrayList<String>();
            ArrayList<String> resourceMap = new ArrayList<String>();
            Double percent = 0.0;
            for (String idString : ids.getItems()) {
                try {
                    Integer id = Integer.parseInt(idString);
                    EnvironmentalExecutionReportItem report = BatchGeneratorObjectFactory.getReport(id, true);
                    if (report == null) {
                        throw new Exception("Execution finished or not yet started");
                    }
                    mapLoad.add(report.getResourceLoad());
                    resourceMap.add(report.getResourcesMap());
                    percent = percent + report.getPercent() / (double)ids.getItems().length;
                }
                catch (Exception e) {
                    this.logger.warn((Object)("Unable to get report, id " + idString), (Throwable)e);
                }
            }
            return new GetGenerationLiveReportResponseType(null, percent.doubleValue(), ResourceFactory.getOverallResourceLoad(mapLoad), ResourceFactory.getOverallResources(resourceMap));
        }
        catch (Exception e) {
            this.logger.error((Object)"Unable to execute request ", (Throwable)e);
            throw new GCUBEFault(new String[]{"ServerSide msg: " + e.getMessage()});
        }
    }

    public RemoveHSPECGroupGenerationRequestResponseType removeHSPECGroup(RemoveHSPECGroupGenerationRequestResponseType arg0) throws RemoteException, GCUBEFault {
        try {
            ArrayList<Field> filter = new ArrayList<Field>();
            filter.add(new Field(SourceGenerationRequestFields.id + "", arg0.getRequestId(), FieldType.STRING));
            SourceGenerationRequest request = SourceGenerationRequestsManager.getList(filter).get(0);
            if (arg0.isRemoveTables()) {
                throw new Exception("REMOVE TABLES NOT YET IMPLEMENTED");
            }
            if (arg0.isRemoveJobs()) {
                throw new Exception("REMOVE JOBS NOT YET IMPLEMENTED");
            }
            SourceGenerationRequestsManager.delete(filter);
            return new RemoveHSPECGroupGenerationRequestResponseType(false, false, request.getId());
        }
        catch (Exception e) {
            this.logger.error((Object)"Unable to execute request ", (Throwable)e);
            throw new GCUBEFault(new String[]{"ServerSide msg: " + e.getMessage()});
        }
    }

    public FieldArray getDefaultSources(VOID arg0) throws RemoteException, GCUBEFault {
        try {
            ArrayList<Field> toReturn = new ArrayList<Field>();
            for (ResourceType type : ResourceType.values()) {
                try {
                    toReturn.add(new Field(type + "", SourceManager.getDefaultId(type) + "", FieldType.INTEGER));
                }
                catch (Exception e) {
                    this.logger.warn((Object)("Unable to locate default table for " + type), (Throwable)e);
                }
            }
            return Field.toStubsVersion(toReturn);
        }
        catch (Exception e) {
            this.logger.error((Object)"Unable to execute request ", (Throwable)e);
            throw new GCUBEFault(new String[]{"ServerSide msg: " + e.getMessage()});
        }
    }

    public Resource editResource(Resource arg0) throws RemoteException, GCUBEFault {
        try {
            this.logger.trace((Object)("Editing resource " + arg0.getSearchId()));
            org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Resource request = new org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Resource(arg0);
            org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Resource toEdit = SourceManager.getById(request.getSearchId());
            toEdit.setTitle(request.getTitle());
            toEdit.setDescription(request.getDescription());
            toEdit.setDefaultSource(request.getDefaultSource());
            toEdit.setDisclaimer(request.getDisclaimer());
            toEdit.setProvenance(request.getProvenance());
            SourceManager.update(toEdit);
            return arg0;
        }
        catch (Exception e) {
            this.logger.error((Object)"Unable to execute request ", (Throwable)e);
            throw new GCUBEFault(new String[]{"ServerSide msg: " + e.getMessage()});
        }
    }

    public VOID editHSPECGroupDetails(HspecGroupGenerationRequestType arg0) throws RemoteException, GCUBEFault {
        try {
            throw new Exception("NOT YET IMPLEMENTED");
        }
        catch (Exception e) {
            this.logger.error((Object)"Unable to execute request ", (Throwable)e);
            throw new GCUBEFault(new String[]{"ServerSide msg: " + e.getMessage()});
        }
    }

    public String exportTableAsCSV(ExportTableRequestType request) throws RemoteException, GCUBEFault {
        try {
            return ExportManager.submitExportOperation(request.getTableName(), request.getCsvSettings());
        }
        catch (Exception e) {
            this.logger.debug((Object)("Unable to export table " + request.getTableName()), (Throwable)e);
            throw new GCUBEFault(new String[]{"Unable to export table " + request.getTableName() + ", cause : " + e.getLocalizedMessage()});
        }
    }

    public VOID removeResource(int arg0) throws RemoteException, GCUBEFault {
        try {
            this.logger.trace((Object)("Removing resource " + arg0));
            org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Resource resource = SourceManager.getById(arg0);
            if (resource != null) {
                List<Submitted> relatedJobs = null;
                ArrayList<SourceGenerationRequest> relatedGenerations = null;
                if (!resource.getType().equals((Object)ResourceType.OCCURRENCECELLS)) {
                    this.logger.trace((Object)("Resource type is " + resource.getType() + ", gathering related jobs..."));
                    ArrayList<Field> jobFilter = new ArrayList<Field>();
                    if (resource.getType().equals((Object)ResourceType.HCAF)) {
                        jobFilter.add(new Field(SubmittedFields.sourcehcaf + "", resource.getSearchId() + "", FieldType.INTEGER));
                    } else if (resource.getType().equals((Object)ResourceType.HSPEN)) {
                        jobFilter.add(new Field(SubmittedFields.sourcehspen + "", resource.getSearchId() + "", FieldType.INTEGER));
                    } else if (resource.getType().equals((Object)ResourceType.HSPEC)) {
                        jobFilter.add(new Field(SubmittedFields.sourcehspec + "", resource.getSearchId() + "", FieldType.INTEGER));
                    }
                    jobFilter.add(new Field(SubmittedFields.isaquamap + "", "false", FieldType.BOOLEAN));
                    relatedJobs = SubmittedManager.getList(jobFilter);
                    this.logger.trace((Object)("Found " + relatedJobs.size() + " related jobs.."));
                    this.logger.trace((Object)"Checking jobs status..");
                    for (Submitted j : relatedJobs) {
                        if (j.getStatus().equals((Object)SubmittedStatus.Completed) || j.getStatus().equals((Object)SubmittedStatus.Error)) continue;
                        throw new Exception("Found pending related jobs [ID : " + j.getSearchId() + "], unable to continue..");
                    }
                    this.logger.trace((Object)"OK");
                }
                if (!resource.getType().equals((Object)ResourceType.HSPEC)) {
                    this.logger.trace((Object)"Checking for pending table generation..");
                    ArrayList<Field> generationFilter = new ArrayList<Field>();
                    SourceGenerationRequest sourceGenerationRequest = new SourceGenerationRequest();
                    sourceGenerationRequest.addSource(resource);
                    if (resource.getType().equals((Object)ResourceType.HCAF)) {
                        generationFilter.add(sourceGenerationRequest.getField(SourceGenerationRequestFields.sourcehcafids));
                    } else if (resource.getType().equals((Object)ResourceType.HSPEN)) {
                        generationFilter.add(sourceGenerationRequest.getField(SourceGenerationRequestFields.sourcehspenids));
                    } else if (resource.getType().equals((Object)ResourceType.OCCURRENCECELLS)) {
                        sourceGenerationRequest.setLogic(LogicType.HSPEN);
                        generationFilter.add(sourceGenerationRequest.getField(SourceGenerationRequestFields.logic));
                        generationFilter.add(sourceGenerationRequest.getField(SourceGenerationRequestFields.sourceoccurrencecellsids));
                    }
                    relatedGenerations = SourceGenerationRequestsManager.getList(generationFilter);
                    this.logger.trace((Object)("Found " + relatedGenerations.size() + " related generations.."));
                    this.logger.trace((Object)"Checking status..");
                    for (SourceGenerationRequest r : relatedGenerations) {
                        if (r.getPhase().equals((Object)SourceGenerationPhase.completed) || r.getPhase().equals((Object)SourceGenerationPhase.error)) continue;
                        throw new Exception("Found pending related requests [ID : " + r.getId() + "], unable to continue..");
                    }
                    this.logger.trace((Object)"OK");
                }
                this.logger.trace((Object)"Checks completed");
                this.logger.trace((Object)"Unregistering..");
                SourceManager.deleteSource(arg0, true);
                this.logger.trace((Object)"Removing Jobs.. ");
                if (relatedJobs != null) {
                    for (Submitted submitted : relatedJobs) {
                        try {
                            SubmittedManager.delete(submitted.getSearchId());
                        }
                        catch (Exception e) {
                            this.logger.warn((Object)("Unable to delete related job " + submitted.getSearchId()), (Throwable)e);
                        }
                    }
                }
                this.logger.trace((Object)"Removing generation Requests .. ");
                if (relatedGenerations != null) {
                    for (SourceGenerationRequest sourceGenerationRequest : relatedGenerations) {
                        try {
                            SourceGenerationRequestsManager.delete(sourceGenerationRequest.getId());
                        }
                        catch (Exception e) {
                            this.logger.warn((Object)("Unable to delete related generation request " + sourceGenerationRequest.getId()), (Throwable)e);
                        }
                    }
                }
            } else {
                throw new Exception("Resource not found, ID was " + arg0);
            }
            this.logger.trace((Object)"Complete");
            return new VOID();
        }
        catch (Exception e) {
            this.logger.error((Object)"Unable to execute request ", (Throwable)e);
            throw new GCUBEFault(new String[]{"ServerSide msg: " + e.getMessage()});
        }
    }

    public String setCustomQuery(SetUserCustomQueryRequestType arg0) throws RemoteException, GCUBEFault {
        try {
            this.logger.trace((Object)("Setting custom query, user : " + arg0.getUser() + ", query : " + arg0.getQueryString()));
            return CustomQueryManager.setUserCustomQuery(arg0.getUser(), arg0.getQueryString());
        }
        catch (Exception e) {
            this.logger.error((Object)"Unable to execute request ", (Throwable)e);
            throw new GCUBEFault(new String[]{"ServerSide msg: " + e.getMessage()});
        }
    }

    public int importResource(ImportResourceRequestType arg0) throws RemoteException, GCUBEFault {
        try {
            this.logger.trace((Object)("Importing resource , user : " + arg0.getUser() + ", locator :" + arg0.getRsLocator()));
            String csvLocation = ServiceContext.getContext().getFolderPath(ServiceContext.FOLDERS.IMPORTS) + File.separator + ServiceUtils.generateId("import", ".csv");
            FileWriter writer = new FileWriter(csvLocation);
            FileInputStream is = new FileInputStream(RSWrapper.getStreamFromLocator((URI)new URI(arg0.getRsLocator())));
            IOUtils.copy((InputStream)is, (Writer)writer, (String)arg0.getCsvSettings().getEncoding());
            IOUtils.closeQuietly((Writer)writer);
            IOUtils.closeQuietly((InputStream)is);
            this.logger.trace((Object)("CSV imported into " + csvLocation));
            return SourceManager.importFromCSVFile(csvLocation, arg0);
        }
        catch (Exception e) {
            this.logger.error((Object)"Unable to execute request ", (Throwable)e);
            throw new GCUBEFault(new String[]{"ServerSide msg: " + e.getMessage()});
        }
    }

    public String viewCustomQuery(ViewCustomQueryRequestType arg0) throws RemoteException, GCUBEFault {
        try {
            return CustomQueryManager.getPagedResult(arg0.getUser(), arg0.getPagedRequestSettings());
        }
        catch (Exception e) {
            this.logger.error((Object)"Unable to execute request ", (Throwable)e);
            throw new GCUBEFault(new String[]{"ServerSide msg: " + e.getMessage()});
        }
    }

    public String analyzeTables(Analysis arg0) throws RemoteException, GCUBEFault {
        try {
            return AnalysisManager.insertRequest(new org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Analysis(arg0));
        }
        catch (Exception e) {
            this.logger.error((Object)"Unable to execute request ", (Throwable)e);
            throw new GCUBEFault(new String[]{"ServerSide msg: " + e.getMessage()});
        }
    }

    public String getJSONSubmittedAnalysis(PagedRequestSettings arg0) throws RemoteException, GCUBEFault {
        try {
            return AnalysisTableManager.getJSONList(new ArrayList<Field>(), arg0);
        }
        catch (Exception e) {
            this.logger.error((Object)"Unable to execute request ", (Throwable)e);
            throw new GCUBEFault(new String[]{"ServerSide msg: " + e.getMessage()});
        }
    }

    public String loadAnalysis(String arg0) throws RemoteException, GCUBEFault {
        try {
            org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Analysis analysis = AnalysisTableManager.getById(arg0);
            GCUBEScope scope = ServiceContext.getContext().getScope();
            this.logger.trace((Object)("Caller scope is " + scope));
            RSWrapper wrapper = new RSWrapper(scope);
            File temp = File.createTempFile("analysis", ".tar.gz");
            FileUtils.Copy((File)new File(analysis.getArchiveLocation()), (File)temp);
            temp.deleteOnExit();
            wrapper.add(temp);
            String locator = wrapper.getLocator().toString();
            this.logger.trace((Object)("Added file to locator " + locator));
            return locator;
        }
        catch (Exception e) {
            this.logger.error((Object)"Unable to execute request ", (Throwable)e);
            throw new GCUBEFault(new String[]{"ServerSide msg: " + e.getMessage()});
        }
    }

    public String resubmitGeneration(String arg0) throws RemoteException, GCUBEFault {
        try {
            org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Resource r;
            long availableSpace = GHNContext.getContext().getFreeSpace(GHNContext.getContext().getLocation());
            long threshold = ServiceContext.getContext().getPropertyAsInteger("MONITOR_FREESPACE_THRESHOLD").intValue();
            if (availableSpace < threshold) {
                throw new Exception("NOT ENOUGH SPACE, REMAINING : " + availableSpace + ", THRESHOLD : " + threshold);
            }
            this.logger.debug((Object)("Resubmitting request " + arg0));
            SourceGenerationRequest request = new SourceGenerationRequest();
            request.setId(arg0);
            request = SourceGenerationRequestsManager.getList(Arrays.asList(request.getField(SourceGenerationRequestFields.id)), new PagedRequestSettings(1, 0, OrderDirection.ASC, SourceGenerationRequestFields.id + "")).get(0);
            for (Integer resId : request.getHcafIds()) {
                r = SourceManager.getById(resId);
                if (r != null && r.getType().equals((Object)ResourceType.HCAF)) continue;
                throw new Exception("Invalid HCAF id " + resId);
            }
            for (Integer resId : request.getHspenIds()) {
                r = SourceManager.getById(resId);
                if (r != null && r.getType().equals((Object)ResourceType.HSPEN)) continue;
                throw new Exception("Invalid HSPEN id " + resId);
            }
            for (Integer resId : request.getOccurrenceCellIds()) {
                r = SourceManager.getById(resId);
                if (r != null && r.getType().equals((Object)ResourceType.OCCURRENCECELLS)) continue;
                throw new Exception("Invalid Occurrence Cells id " + resId);
            }
            request.setGenerationname(request.getGenerationname() + "_reLaunch");
            return TableGenerationExecutionManager.insertRequest(request);
        }
        catch (Exception e) {
            this.logger.error((Object)"Unable to execute request ", (Throwable)e);
            throw new GCUBEFault(new String[]{"ServerSide msg: " + e.getMessage()});
        }
    }

    public VOID deleteAnalysis(String arg0) throws RemoteException, GCUBEFault {
        try {
            AnalysisTableManager.delete(arg0);
            return new VOID();
        }
        catch (Exception e) {
            this.logger.error((Object)("Unable to delete Analysis " + arg0), (Throwable)e);
            throw new GCUBEFault(new String[]{"ServerSide msg: " + e.getMessage()});
        }
    }

    public CustomQueryDescriptorStubs getCustomQueryDescriptor(String request) throws RemoteException, GCUBEFault {
        try {
            return CustomQueryManager.getDescriptor(request).toStubsVersion();
        }
        catch (Exception e) {
            this.logger.error((Object)("Unable to get descriptor for custom query " + request), (Throwable)e);
            throw new GCUBEFault(new String[]{"ServerSide msg: " + e.getMessage()});
        }
    }

    public ExportTableStatusType getExportStatus(String request) throws RemoteException, GCUBEFault {
        try {
            return ExportManager.getStatus(request);
        }
        catch (Exception e) {
            this.logger.error((Object)("Unable to get status for export operation " + request), (Throwable)e);
            throw new GCUBEFault(new String[]{"ServerSide msg: " + e.getMessage()});
        }
    }
}

