/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.service.engine.providers;

import java.util.HashMap;
import java.util.Map;
import org.gcube.application.cms.caches.AbstractScopedMap;
import org.gcube.application.cms.plugins.InitializablePlugin;
import org.gcube.application.cms.plugins.LifecycleManager;
import org.gcube.application.cms.plugins.Plugin;
import org.gcube.application.cms.plugins.PluginManagerInterface;
import org.gcube.application.cms.plugins.PluginsReflections;
import org.gcube.application.cms.plugins.faults.InitializationException;
import org.gcube.application.cms.plugins.faults.PluginExecutionException;
import org.gcube.application.cms.plugins.faults.ShutDownException;
import org.gcube.application.cms.plugins.reports.InitializationReport;
import org.gcube.application.geoportal.common.model.rest.ConfigurationException;
import org.gcube.application.geoportal.service.engine.providers.PluginManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class PluginManager
extends AbstractScopedMap<PluginMap>
implements PluginManagerInterface {
    private static final Logger log = LoggerFactory.getLogger(PluginManager.class);
    PluginMap implementations = new PluginMap();

    public PluginManager() {
        super("Plugin Cache");
        this.implementations.putAll(PluginsReflections.load());
        log.info("Loaded {} plugins", (Object)this.implementations.keySet().size());
        this.implementations.forEach((id, p) -> {
            log.info("Registering plugin Manager ");
            if (p instanceof LifecycleManager) {
                log.debug("Registering plugin Manager to {} ", id);
                ((LifecycleManager)p).setPluginManager((PluginManagerInterface)this);
            }
            if (p instanceof InitializablePlugin) {
                log.info("INIT Plugin {}", id);
                try {
                    InitializablePlugin ip = (InitializablePlugin)p;
                    PluginManager.logReport((Plugin)ip, (InitializationReport)ip.init());
                }
                catch (InitializationException e) {
                    log.error("Failed to initialize " + id, (Throwable)e);
                }
                catch (Throwable t) {
                    log.error("Unable to initialize " + id, t);
                }
            }
        });
    }

    protected PluginMap retrieveObject(String context) throws ConfigurationException {
        log.warn("PLUGIN INITIALIZTIONS IN CONTEXT {} ", (Object)context);
        this.implementations.forEach((id, p) -> {
            if (p instanceof InitializablePlugin) {
                log.info("INIT Plugin {} in context {} ", id, (Object)context);
                try {
                    InitializablePlugin ip = (InitializablePlugin)p;
                    PluginManager.logReport((Plugin)ip, (InitializationReport)ip.initInContext());
                }
                catch (InitializationException e) {
                    log.error("Failed to initialize " + id, (Throwable)e);
                }
                catch (Throwable t) {
                    log.error("Unable to initialize " + id, t);
                }
            }
        });
        return this.implementations;
    }

    protected void dispose(PluginMap toDispose) {
        this.implementations.forEach((id, p) -> {
            if (p instanceof InitializablePlugin) {
                log.info("Shutting down Plugin {}", id);
                try {
                    InitializablePlugin ip = (InitializablePlugin)p;
                    ip.shutdown();
                }
                catch (ShutDownException e) {
                    log.error("Failed to shutdown " + id, (Throwable)e);
                }
                catch (Throwable t) {
                    log.error("Unable to shutdown " + id, t);
                }
            }
        });
    }

    public void init() {
    }

    public Plugin getById(String pluginID) throws ConfigurationException {
        Plugin toReturn = (Plugin)((PluginMap)this.getObject()).get((Object)pluginID);
        if (toReturn == null) {
            throw new ConfigurationException("Plugin " + pluginID + " not found ");
        }
        return toReturn;
    }

    private static final void logReport(Plugin p, InitializationReport report) {
        if (report == null) {
            log.warn("WARNING : Initialization Report by {} IS null ", (Object)p.getDescriptor().getId());
        } else {
            try {
                report.validate();
                switch (1.$SwitchMap$org$gcube$application$cms$plugins$reports$Report$Status[report.getStatus().ordinal()]) {
                    case 1: {
                        log.error("Plugin [{}] STATUS : {}, INFO {} ", new Object[]{p.getDescriptor().getId(), report.getStatus(), report.getMessages()});
                        break;
                    }
                    case 2: {
                        log.warn("Plugin [{}] STATUS : {}, INFO {} ", new Object[]{p.getDescriptor().getId(), report.getStatus(), report.getMessages()});
                        break;
                    }
                    default: {
                        log.info("Plugin [{}] STATUS : {}, INFO {} ", new Object[]{p.getDescriptor().getId(), report.getStatus(), report.getMessages()});
                        break;
                    }
                }
            }
            catch (PluginExecutionException e) {
                log.warn("Invalid report provided by {} ", (Object)p.getDescriptor().getId(), (Object)e);
            }
        }
    }

    public Map<String, Plugin> getByType(String type) throws ConfigurationException {
        HashMap<String, Plugin> toReturn = new HashMap<String, Plugin>();
        ((PluginMap)this.getObject()).forEach((s, plugin) -> {
            if (plugin != null && plugin.getDescriptor().getType().equals(type)) {
                toReturn.put((String)s, (Plugin)plugin);
            }
        });
        return toReturn;
    }
}

