/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.service.engine.cache;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import org.gcube.application.geoportal.model.fault.ConfigurationException;
import org.gcube.application.geoportal.service.engine.AbstractScopedMap;
import org.gcube.application.geoportal.service.engine.ImplementationProvider;
import org.gcube.application.geoportal.service.model.internal.db.MongoConnection;

public class MongoClientProvider
extends AbstractScopedMap<MongoClient> {
    public MongoClientProvider() {
        super("MongoClient cache");
    }

    protected MongoClient retrieveObject() throws ConfigurationException {
        MongoConnection conn = (MongoConnection)ImplementationProvider.get().getMongoConnectionProvider().getObject();
        MongoCredential credential = MongoCredential.createCredential((String)conn.getUser(), (String)conn.getDatabase(), (char[])conn.getPassword().toCharArray());
        MongoClientOptions options = MongoClientOptions.builder().sslEnabled(true).build();
        return new MongoClient(new ServerAddress((String)conn.getHosts().get(0), conn.getPort()), credential, options);
    }

    protected void dispose(MongoClient toDispose) {
        toDispose.close();
    }

    public void init() {
    }
}

