/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.service.engine;

import org.gcube.application.geoportal.managers.AbstractRecordManager;
import org.gcube.application.geoportal.managers.EMFProvider;
import org.gcube.application.geoportal.service.engine.ScopedEMFProvider;
import org.gcube.application.geoportal.service.engine.StorageClientProvider;
import org.gcube.application.geoportal.service.engine.StorageHubProvider;
import org.gcube.application.geoportal.service.engine.cache.MongoClientProvider;
import org.gcube.application.geoportal.service.engine.cache.MongoConnectionProvider;

public class ImplementationProvider {
    private static final Object $LOCK = new Object[0];
    private static ImplementationProvider instance = null;
    private MongoConnectionProvider mongoConnectionProvider = new MongoConnectionProvider();
    private MongoClientProvider mongoClientProvider = new MongoClientProvider();
    private StorageClientProvider storageProvider = new StorageClientProvider();
    private EMFProvider emfProvider = new ScopedEMFProvider();
    private StorageHubProvider sHubProvider = new StorageHubProvider();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImplementationProvider get() {
        Object object = $LOCK;
        synchronized (object) {
            if (instance == null) {
                instance = new ImplementationProvider();
            }
            return instance;
        }
    }

    public void shutdown() {
        AbstractRecordManager.shutdown();
        this.mongoConnectionProvider.shustdown();
        this.mongoClientProvider.shustdown();
    }

    public void startup() {
        AbstractRecordManager.setDefaultProvider((EMFProvider)this.emfProvider);
        this.mongoConnectionProvider.init();
        this.mongoClientProvider.init();
    }

    public MongoConnectionProvider getMongoConnectionProvider() {
        return this.mongoConnectionProvider;
    }

    public void setMongoConnectionProvider(MongoConnectionProvider mongoConnectionProvider) {
        this.mongoConnectionProvider = mongoConnectionProvider;
    }

    public MongoClientProvider getMongoClientProvider() {
        return this.mongoClientProvider;
    }

    public void setMongoClientProvider(MongoClientProvider mongoClientProvider) {
        this.mongoClientProvider = mongoClientProvider;
    }

    public StorageClientProvider getStorageProvider() {
        return this.storageProvider;
    }

    public void setStorageProvider(StorageClientProvider storageProvider) {
        this.storageProvider = storageProvider;
    }

    public EMFProvider getEmfProvider() {
        return this.emfProvider;
    }

    public void setEmfProvider(EMFProvider emfProvider) {
        this.emfProvider = emfProvider;
    }

    public StorageHubProvider getSHubProvider() {
        return this.sHubProvider;
    }

    public void setSHubProvider(StorageHubProvider sHubProvider) {
        this.sHubProvider = sHubProvider;
    }
}

