/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.service.engine.mongo;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;
import org.gcube.application.geoportal.common.model.legacy.Concessione;
import org.gcube.application.geoportal.model.db.DBConstants;
import org.gcube.application.geoportal.model.db.PostgisTable;
import org.gcube.application.geoportal.model.fault.ConfigurationException;
import org.gcube.application.geoportal.model.fault.PublishException;
import org.gcube.application.geoportal.service.engine.SDIManager;
import org.gcube.application.geoportal.service.model.internal.faults.SDIInteractionException;
import org.gcube.application.geoportal.service.utils.Serialization;
import org.gcube.application.geoportal.storage.PostgisDBManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class PostgisIndex {
    private static final Logger log = LoggerFactory.getLogger(PostgisIndex.class);
    @NonNull
    private Concessione record;
    private SDIManager sdiManager;

    public PostgisIndex(Concessione record) throws SDIInteractionException {
        this.record = record;
        this.sdiManager = new SDIManager();
    }

    protected PostgisTable getCentroidsTable() {
        return DBConstants.Concessioni.CENTROIDS;
    }

    public void registerCentroid() throws PublishException {
        try {
            log.debug("Evaluating Centroid");
            Map centroidRow = this.evaluateCentroid();
            log.debug("Contacting postgis DB .. ");
            PostgisDBManager db = PostgisDBManager.get();
            PostgisTable centroidsTable = this.getCentroidsTable();
            log.debug("Inserting / updated centroid Row {} ", (Object)centroidRow);
            PreparedStatement ps = db.prepareInsertStatement(centroidsTable, true, true);
            log.debug("Deleting centroid if present. ID is " + this.record.getId());
            db.deleteByFieldValue(centroidsTable, new PostgisTable.Field("product_id", PostgisTable.FieldType.TEXT), (Object)(this.record.getId() + ""));
            centroidsTable.fillCSVPreparedStatament(centroidRow, ps, false);
            ps.executeUpdate();
            db.commit();
            this.initCentroidLayer();
        }
        catch (SQLException e) {
            log.warn("Unable to publish Centroid for record " + this.record, (Throwable)e);
            throw new PublishException("Unable to publish centroid.", (Throwable)e, null);
        }
        catch (SDIInteractionException e) {
            log.warn("Unable to publish Centroid Layer for record type " + this.getRecord().getRecordType(), (Throwable)e);
            throw new PublishException("Unable to publish centroid.", (Throwable)e, null);
        }
        catch (ConfigurationException e) {
            log.warn("Unable to contact centroids db " + this.getRecord().getRecordType(), (Throwable)e);
            throw new PublishException("Unable to publish centroid.", (Throwable)e, null);
        }
    }

    protected void initCentroidLayer() throws SDIInteractionException {
        log.debug("Checking for centroid layer configuration.. ");
        this.sdiManager.configureCentroidLayer("centroids_concessioni", "gna", "gna_postgis");
    }

    public void removeCentroid() {
        try {
            PostgisDBManager db = PostgisDBManager.get();
            PostgisTable centroidsTable = this.getCentroidsTable();
            log.debug("Deleting centroid if present. ID is " + this.record.getId());
            db.deleteByFieldValue(centroidsTable, new PostgisTable.Field("product_id", PostgisTable.FieldType.TEXT), (Object)(this.record.getId() + ""));
        }
        catch (Exception e) {
            log.warn("Unable to remove centroid ", (Throwable)e);
        }
    }

    protected Map<String, String> evaluateCentroid() {
        HashMap<String, String> centroidsRow = new HashMap<String, String>();
        centroidsRow.put("product_id", this.record.getId() + "");
        centroidsRow.put("anno", this.record.getDataInizioProgetto().getYear() + "");
        centroidsRow.put("nome", this.record.getNome());
        centroidsRow.put("regione", "");
        if (this.record.getCentroidLat() == null || this.record.getCentroidLat() == 0.0) {
            try {
                log.debug("Evaluating Centroid latitude for record " + this.record);
                this.record.setCentroidLat(Double.valueOf((this.record.getPosizionamentoScavo().getBbox().getMaxLat() + this.record.getPosizionamentoScavo().getBbox().getMinLat()) / 2.0));
            }
            catch (Throwable t) {
                log.warn("Unable to evaluate centroid latitude " + t);
            }
        }
        if (this.record.getCentroidLong() == null || this.record.getCentroidLong() == 0.0) {
            try {
                log.debug("Evaluating Centroid Longituted for record " + this.record);
                this.record.setCentroidLong(Double.valueOf((this.record.getPosizionamentoScavo().getBbox().getMaxLong() + this.record.getPosizionamentoScavo().getBbox().getMinLong()) / 2.0));
            }
            catch (Throwable t) {
                log.warn("Unable to evaluate centroid latitude " + t);
            }
        }
        centroidsRow.put("xcoord", this.record.getCentroidLong() + "");
        centroidsRow.put("ycoord", this.record.getCentroidLat() + "");
        centroidsRow.put("descrizione", this.record.getIntroduzione());
        centroidsRow.put("contenuto", this.record.getDescrizioneContenuto());
        centroidsRow.put("autore", PostgisIndex.asString((Collection)this.record.getAuthors()));
        centroidsRow.put("contributore", this.record.getContributore());
        centroidsRow.put("titolare", PostgisIndex.asString((Collection)this.record.getTitolari()));
        centroidsRow.put("responsabile", this.record.getResponsabile());
        centroidsRow.put("editore", this.record.getEditore());
        centroidsRow.put("finanziamento", PostgisIndex.asString((Collection)this.record.getFontiFinanziamento()));
        centroidsRow.put("soggetto", PostgisIndex.asString((Collection)this.record.getSoggetto()));
        centroidsRow.put("risorse", PostgisIndex.asString((Collection)this.record.getRisorseCorrelate()));
        centroidsRow.put("date_scavo", Serialization.FULL_FORMATTER.format(this.record.getDataFineProgetto()));
        centroidsRow.put("data_archiviazione", Serialization.FULL_FORMATTER.format(this.record.getLastUpdateTime()));
        centroidsRow.put("versione", this.record.getVersion());
        centroidsRow.put("licenza", this.record.getLicenzaID());
        centroidsRow.put("titolare_licenza", PostgisIndex.asString((Collection)this.record.getTitolareLicenza()));
        centroidsRow.put("accesso", this.record.getPolicy().toString());
        centroidsRow.put("parole_chiave", PostgisIndex.asString((Collection)this.record.getParoleChiaveLibere()));
        return centroidsRow;
    }

    private static String asString(Collection<?> coll) {
        if (coll == null || coll.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (Object t : coll) {
            builder.append(t.toString() + ",");
        }
        return builder.substring(0, builder.lastIndexOf(","));
    }

    @NonNull
    public Concessione getRecord() {
        return this.record;
    }
}

