/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.service.utils;

import java.util.List;
import java.util.Map;
import org.gcube.application.geoportal.common.model.rest.DatabaseConnection;
import org.gcube.application.geoportal.service.model.internal.db.MongoConnection;
import org.gcube.application.geoportal.service.model.internal.faults.ConfigurationException;
import org.gcube.common.encryption.encrypter.StringEncrypter;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ISUtils {
    public DatabaseConnection queryForDB(String platform, String flag) throws ConfigurationException {
        return ISUtils.performQueryForDB((String)platform, (String)flag);
    }

    private static DatabaseConnection performQueryForDB(String platform, String flag) throws ConfigurationException {
        List found = ISUtils.performGetAP((String)platform, (String)flag);
        if (found.size() > 1) {
            throw new ConfigurationException("Multiple SE found [" + found.size() + "] for platform : " + platform + " flag : " + flag);
        }
        if (found.isEmpty()) {
            throw new ConfigurationException("No SE found for platform : " + platform + " flag : " + flag);
        }
        ServiceEndpoint.AccessPoint point = (ServiceEndpoint.AccessPoint)found.get(0);
        DatabaseConnection toReturn = new DatabaseConnection();
        toReturn.setPwd(ISUtils.decryptString((String)point.password()));
        toReturn.setUser(point.username());
        toReturn.setUrl(point.address());
        return toReturn;
    }

    private static List<ServiceEndpoint.AccessPoint> performGetAP(String platform, String flag) {
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        query.addCondition("$resource/Profile/Category/text() eq 'Database'").addCondition("$resource/Profile/Platform/Name/text() eq '" + platform + "'").addCondition("$resource/Profile/AccessPoint//Property[Name/text() eq 'GNA_DB'][Value/text() eq '" + flag + "']").setResult("$resource/Profile/AccessPoint");
        DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.AccessPoint.class);
        return client.submit((Query)query);
    }

    public MongoConnection queryForMongoDB(String platform, String flag) throws ConfigurationException {
        return ISUtils.performQueryForMongoDB((String)platform, (String)flag);
    }

    private static MongoConnection performQueryForMongoDB(String platform, String flag) throws ConfigurationException {
        List found = ISUtils.performGetAP((String)platform, (String)flag);
        if (found.size() > 1) {
            throw new ConfigurationException("Multiple SE found [" + found.size() + "] for platform : " + platform + " flag : " + flag);
        }
        if (found.isEmpty()) {
            throw new ConfigurationException("No SE found for platform : " + platform + " flag : " + flag);
        }
        ServiceEndpoint.AccessPoint point = (ServiceEndpoint.AccessPoint)found.get(0);
        MongoConnection toReturn = new MongoConnection();
        for (ServiceEndpoint.Property prop : point.properties()) {
            switch (prop.name()) {
                case "host": {
                    toReturn.getHosts().add(prop.value());
                }
            }
        }
        toReturn.getHosts().add(point.address());
        Map props = point.propertyMap();
        toReturn.setDatabase(((ServiceEndpoint.Property)props.get("database")).value());
        toReturn.setPassword(ISUtils.decryptString((String)point.password()));
        toReturn.setPort(Integer.parseInt(((ServiceEndpoint.Property)props.get("port")).value()));
        toReturn.setUser(point.username());
        return toReturn;
    }

    private static String decryptString(String toDecrypt) {
        try {
            return StringEncrypter.getEncrypter().decrypt(toDecrypt);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to decrypt : " + toDecrypt, e);
        }
    }
}

