/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.images;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.gcube.application.aquamaps.images.Common;
import org.gcube.application.aquamaps.images.exceptions.ImageNotFoundException;
import org.gcube.application.aquamaps.images.exceptions.InvalidRequestException;
import org.gcube.application.aquamaps.images.model.ProductType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseServlet
extends HttpServlet {
    private static final long serialVersionUID = 3028949525505728303L;
    protected static final Logger logger = LoggerFactory.getLogger(BaseServlet.class);
    protected static Common common = Common.get();
    private static final String SPECIES_PARAM = "species";
    private static final String PRODUCT_PARAM = "product";
    private static final String SUITABLE = "suitable";
    private static final String SUITABLE_2050 = "suitable/2050";
    private static final String NATIVE = "native";
    private static final String NATIVE_2050 = "native/2050";

    protected abstract InputStream handleRequest(HttpServletRequest var1, HttpServletResponse var2) throws IOException, ImageNotFoundException, InvalidRequestException, Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        InputStream is = null;
        try {
            is = this.handleRequest(req, resp);
            IOUtils.copy((InputStream)is, (OutputStream)resp.getOutputStream());
        }
        catch (IOException e) {
            logger.debug("IOException ", (Throwable)e);
            is = common.getImageNotFound();
            IOUtils.copy((InputStream)is, (OutputStream)resp.getOutputStream());
        }
        catch (ImageNotFoundException e) {
            logger.debug("ImageNotFound ", (Throwable)e);
            is = common.getImageNotFound();
            IOUtils.copy((InputStream)is, (OutputStream)resp.getOutputStream());
        }
        catch (InvalidRequestException e) {
            logger.debug("BAD Request ", (Throwable)e);
            resp.setStatus(400);
        }
        catch (Exception e) {
            logger.error("Unexpected error ", (Throwable)e);
            resp.setStatus(500);
        }
        finally {
            if (is != null) {
                IOUtils.closeQuietly((InputStream)is);
            }
            try {
                IOUtils.closeQuietly((OutputStream)resp.getOutputStream());
            }
            catch (Throwable t) {
                logger.error("", t);
            }
        }
    }

    protected static final boolean hasScientificName(HttpServletRequest req) {
        return req.getParameter(SPECIES_PARAM) != null;
    }

    protected static final String getScientificName(HttpServletRequest req) {
        return req.getParameter(SPECIES_PARAM).toLowerCase();
    }

    protected static final int getHSPECId(HttpServletRequest req) throws InvalidRequestException {
        String mapType = req.getPathInfo().substring(1);
        logger.debug("request Hspec is " + mapType);
        Map config = common.getLastConfiguration();
        if (mapType.equals(SUITABLE)) {
            return Integer.parseInt((String)config.get("SUITABLE_ID"));
        }
        if (mapType.equals(SUITABLE_2050)) {
            return Integer.parseInt((String)config.get("SUITABLE_2050_ID"));
        }
        if (mapType.equals(NATIVE)) {
            return Integer.parseInt((String)config.get("NATIVE_ID"));
        }
        if (mapType.equals(NATIVE_2050)) {
            return Integer.parseInt((String)config.get("SUITABLE_2050_ID"));
        }
        try {
            return Integer.parseInt(mapType);
        }
        catch (Exception e) {
            throw new InvalidRequestException();
        }
    }

    protected static final ProductType getProductType(HttpServletRequest req) throws InvalidRequestException {
        if (req.getParameter(PRODUCT_PARAM) != null) {
            try {
                return ProductType.valueOf((String)req.getParameter(PRODUCT_PARAM));
            }
            catch (Exception e) {
                throw new InvalidRequestException();
            }
        }
        return ProductType.IMAGE;
    }
}

