/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.tm.consumers;

import java.io.Reader;
import java.io.StringReader;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.notifier.ISNotifier;
import org.gcube.common.core.resources.GCUBEGenericResource;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.tm.activationrecord.ActivationRecord;
import org.gcube.data.tm.activationrecord.ActivationRecordBody;
import org.gcube.data.tm.context.ServiceContext;
import org.gcube.data.tm.context.TBinderContext;
import org.gcube.data.tm.state.TBinderResource;

public class ActivationRecordConsumer
extends ISNotifier.BaseNotificationConsumer {
    private GCUBELog logger = new GCUBELog(ActivationRecordConsumer.class);
    private GCUBEScope scope;

    public ActivationRecordConsumer(GCUBEScope scope) {
        this.scope = scope;
    }

    public void onNotificationReceived(ISNotifier.NotificationEvent event) {
        try {
            String id = ((ISNotifier.NotificationMessage)event.getPayload()).getMessage()[0].getChildNodes().item(0).getChildNodes().item(0).getNodeValue();
            String profile = ((ISNotifier.NotificationMessage)event.getPayload()).getMessage()[0].getChildNodes().item(1).getChildNodes().item(0).getNodeValue();
            String operation = ((ISNotifier.NotificationMessage)event.getPayload()).getMessage()[0].getChildNodes().item(2).getChildNodes().item(0).getNodeValue();
            GCUBEGenericResource resource = null;
            try {
                resource = (GCUBEGenericResource)GHNContext.getImplementation(GCUBEGenericResource.class);
                resource.load((Reader)new StringReader(profile));
            }
            catch (Exception e) {
                this.logger.warn((Object)("could not parse generic resource " + id));
            }
            if (resource.getSecondaryType().equals("ActivationRecord") && operation.equals("create")) {
                this.onNewActivationRecord(ActivationRecord.newInstance(resource));
            }
        }
        catch (Throwable e) {
            this.logger.error((Object)("could not process event " + event), e);
        }
    }

    public void onNewActivationRecord(ActivationRecord record) {
        try {
            TBinderResource binder = TBinderContext.getContext().binder();
            ServiceContext context = ServiceContext.getContext();
            ActivationRecordBody body = record.getBody();
            if (body.getCreatedBy().equals(context.getInstance().getID()) || binder.getPlugin(body.getParameters().getPlugin()) == null || binder.knowsActivation(record)) {
                this.logger.trace((Object)("discarding AR " + record.getResource().getID()));
                return;
            }
            this.logger.trace((Object)("processing AR \n" + record.getResource().getBody()));
            context.setScope(this.scope);
            context.useServiceCredentials(new Thread[0]);
            binder.bind(body.getParameters().getPlugin(), body.getParameters().getPayload());
            binder.addActivation(record);
        }
        catch (Exception e) {
            this.logger.warn((Object)("could not process AR " + record.getResource().getID()), (Throwable)e);
        }
    }
}

