/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.tm.services;

import java.util.List;
import org.gcube.common.core.faults.FaultUtils;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.faults.GCUBERetryEquivalentFault;
import org.gcube.common.core.scope.GCUBEScopeManager;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.utils.handlers.GCUBEScheduledHandler;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.tm.activationrecord.ActivationRecord;
import org.gcube.data.tm.activationrecord.ActivationRecordBody;
import org.gcube.data.tm.context.ServiceContext;
import org.gcube.data.tm.context.TBinderContext;
import org.gcube.data.tm.publishers.ResilientScheduler;
import org.gcube.data.tm.state.TBinderResource;
import org.gcube.data.tm.stubs.BindParameters;
import org.gcube.data.tm.stubs.InvalidRequestFault;
import org.gcube.data.tm.stubs.SourceBinding;
import org.gcube.data.tm.stubs.SourceBindings;
import org.gcube.data.tm.utils.BindParametersWrapper;
import org.gcube.data.tmf.api.exceptions.InvalidRequestException;

public class TBinderService {
    private static GCUBELog logger = new GCUBELog(TBinderService.class);

    public SourceBindings bind(BindParameters parameters) throws InvalidRequestFault, GCUBEFault {
        return this.bind(new BindParametersWrapper(parameters));
    }

    SourceBindings bind(BindParametersWrapper parameters) throws InvalidRequestFault, GCUBEFault {
        try {
            if (parameters == null) {
                throw new InvalidRequestException("request carries null parameters");
            }
            String pluginName = parameters.getPlugin();
            TBinderResource binder = TBinderContext.getContext().binder();
            if (parameters.isBroadcast() && binder.getPlugin(pluginName).isAnchored()) {
                throw new InvalidRequestException("cannot broadcast: plugin is anchored, its state cannot be replicated");
            }
            List<SourceBinding> bindings = binder.bind(pluginName, parameters.getPayload());
            if (bindings.size() > 0 && parameters.isBroadcast()) {
                this.buildAndPublishActivationRecord(binder, parameters);
            }
            return new SourceBindings(bindings.toArray(new SourceBinding[0]));
        }
        catch (InvalidRequestException e) {
            throw (InvalidRequestFault)FaultUtils.newFault((GCUBEFault)new InvalidRequestFault(), (Throwable)e);
        }
        catch (Exception e) {
            throw (GCUBERetryEquivalentFault)FaultUtils.newFault((GCUBEFault)new GCUBERetryEquivalentFault(), (Throwable)e);
        }
    }

    private void buildAndPublishActivationRecord(TBinderResource binder, BindParametersWrapper parameters) {
        try {
            String id = ServiceContext.getContext().getInstance().getID();
            ActivationRecordBody body = new ActivationRecordBody(id, parameters);
            String description = "An activation of the T-Binder Service";
            ActivationRecord record = ActivationRecord.newInstance(description, body);
            ResilientScheduler scheduler = new ResilientScheduler(1L, GCUBEScheduledHandler.Mode.LAZY);
            scheduler.setAttempts(10);
            scheduler.setDelay(10L);
            scheduler.setScopeManager((GCUBEScopeManager)ServiceContext.getContext());
            scheduler.setSecurityManager((GCUBESecurityManager)ServiceContext.getContext());
            record.publish(scheduler);
            binder.addActivation(record);
        }
        catch (Throwable t) {
            logger.error((Object)("could not publish activation record " + parameters), t);
        }
    }
}

