/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.executor.nodes.transducers;

import java.io.File;
import java.util.List;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveType;
import org.gcube.dataanalysis.ecoengine.datatypes.ServiceType;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.PrimitiveTypes;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.ServiceParameters;
import org.gcube.dataanalysis.ecoengine.interfaces.StandardLocalInfraAlgorithm;
import org.gcube.dataanalysis.executor.util.DataTransferer;
import org.gcube.dataanalysis.executor.util.InfraRetrieval;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebApplicationPublisher
extends StandardLocalInfraAlgorithm {
    private static final String DATA_TRANSFER_PERSISTENCE_ID = "data-transfer-service";
    private static String FileParam = "ZipFile";
    private String transferServiceAddress = "";
    private int transferServicePort = 0;
    private Logger LOGGER = LoggerFactory.getLogger(WebApplicationPublisher.class);

    public String getDescription() {
        return "This algorithm publishes a zip file containing a Web site, based on html and javascript in the e-Infrastructure. It generates a public URL to the application that can be shared.";
    }

    public void init() throws Exception {
    }

    protected void process() throws Exception {
        String uuid = "webpub_" + UUID.randomUUID();
        File folder = new File(this.config.getConfigPath(), uuid);
        try {
            this.status = 10.0f;
            String scope = this.config.getGcubeScope();
            String username = this.config.getParam("ServiceUserName");
            String fileAbsolutePath = this.config.getParam(FileParam);
            this.LOGGER.debug("scope: {}", (Object)scope);
            this.LOGGER.debug("username: {}", (Object)username);
            this.LOGGER.debug("fileAbsolutePath: {}", (Object)fileAbsolutePath);
            if (scope == null || username == null) {
                throw new Exception("Service parameters are not set - please contact the Administrators");
            }
            if (fileAbsolutePath == null || fileAbsolutePath.trim().length() == 0) {
                throw new Exception("No file has been provided to the process");
            }
            this.getTransferInfo(this.config.getGcubeScope());
            DataTransferer.transferFileToService(scope, username, this.transferServiceAddress, this.transferServicePort, fileAbsolutePath, "", DATA_TRANSFER_PERSISTENCE_ID, true, uuid);
            String producedPage = "http://" + this.transferServiceAddress + "/" + uuid + "/";
            this.LOGGER.debug("Entry point of the page " + producedPage);
            this.addOutputString("Generated Website - Main URL", producedPage);
        }
        catch (Exception e) {
            this.LOGGER.error("an error occurred!", (Throwable)e);
            throw e;
        }
        finally {
            if (folder.exists()) {
                this.LOGGER.debug("Cleaning folder " + folder);
                FileUtils.cleanDirectory((File)folder);
                FileUtils.deleteDirectory((File)folder);
            }
        }
        this.LOGGER.debug("Process finished");
        this.status = 100.0f;
    }

    protected void setInputParameters() {
        this.inputs.add(new PrimitiveType(File.class.getName(), null, PrimitiveTypes.FILE, FileParam, "Zip file containing the Web site"));
        this.inputs.add(new ServiceType(ServiceParameters.USERNAME, "ServiceUserName", "The final user Name"));
    }

    public void shutdown() {
        this.LOGGER.debug("WebApplicationPublisher - shutdown");
    }

    public void getTransferInfo(String scope) throws Exception {
        List<String> apacheAddress = InfraRetrieval.retrieveServiceAddress("Application", "Apache Server", scope, "Transect");
        if (apacheAddress.size() == 0) {
            throw new Exception("Apache Server resource is not available in scope " + scope);
        }
        String apacheServiceAddress = apacheAddress.get(0);
        apacheServiceAddress = apacheServiceAddress.substring(apacheServiceAddress.indexOf("http://") + 7);
        this.LOGGER.debug("Found {} services", (Object)apacheAddress.size());
        this.LOGGER.debug("Apache address: {}", (Object)apacheServiceAddress);
        List<String> dataTransferAddress = InfraRetrieval.retrieveService(DATA_TRANSFER_PERSISTENCE_ID, scope);
        if (dataTransferAddress.size() == 0) {
            throw new Exception("Data Transfer services are not available in scope " + scope);
        }
        this.LOGGER.debug("Found {} transfer services", (Object)dataTransferAddress.size());
        int apacheDTPort = 9090;
        boolean found = false;
        for (String datatransferservice : dataTransferAddress) {
            this.LOGGER.debug("Transfer service found");
            datatransferservice = datatransferservice.substring(datatransferservice.indexOf("http://") + 7);
            String servicehost = datatransferservice.substring(0, datatransferservice.indexOf(":"));
            String serviceport = datatransferservice.substring(datatransferservice.indexOf(":") + 1, datatransferservice.indexOf("/"));
            this.LOGGER.debug("Transfer service: {} , {}", (Object)servicehost, (Object)serviceport);
            if (!apacheServiceAddress.equals(servicehost)) continue;
            apacheDTPort = Integer.parseInt(serviceport);
            found = true;
            break;
        }
        if (!found) {
            throw new Exception("Apache data transfer has not been found in the same scope of the catalog: " + scope);
        }
        this.LOGGER.debug("Transfer service found at address {} : {}", (Object)apacheServiceAddress, (Object)apacheDTPort);
        this.transferServiceAddress = apacheServiceAddress;
        this.transferServicePort = apacheDTPort;
    }
}

