/*
 * Decompiled with CFR 0.152.
 */
package com.control_menu.custom;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.product.navigation.control.menu.ProductNavigationControlMenuEntry;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, property={"product.navigation.control.menu.category.key=user", "product.navigation.control.menu.category.order:Integer=0"}, service={ProductNavigationControlMenuEntry.class})
public class AdminLinksControlMenuEntry
implements ProductNavigationControlMenuEntry {
    public String getLabel(Locale locale) {
        return "Admin Links";
    }

    public String getMarkupView(HttpServletRequest request) {
        return "";
    }

    public String getURL(HttpServletRequest request) {
        return "javascript:void(0);";
    }

    public String getLinkCssClass(HttpServletRequest httpServletRequest) {
        return "control-menu-nav-link";
    }

    public boolean includeBody(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        try (InputStream is = this.getClass().getClassLoader().getResourceAsStream("admin-links.html");){
            if (is != null) {
                String html = new String(is.readAllBytes(), StandardCharsets.UTF_8);
                Portlet sitesPortlet = PortletLocalServiceUtil.getPortletById((long)themeDisplay.getCompanyId(), (String)"com_liferay_site_navigation_admin_web_portlet_SitesAdminPortlet");
                String sitesUrl = themeDisplay.getPortalURL() + "/group/control_panel?refererPlid=" + themeDisplay.getPlid() + "&doAsGroupId=" + themeDisplay.getScopeGroupId() + "&controlPanelCategory=current_site.sites&p_p_id=" + sitesPortlet.getPortletId();
                html = html.replace("{{sitesAdminLink}}", "<li><a href=\"" + sitesUrl + "\">&gt; Sites Administration</a></li>");
                Portlet pagesPortlet = PortletLocalServiceUtil.getPortletById((long)themeDisplay.getCompanyId(), (String)"com_liferay_site_navigation_admin_web_portlet_SitesAdminPortlet");
                String pagesUrl = themeDisplay.getPortalURL() + "/group/control_panel?refererPlid=" + themeDisplay.getPlid() + "&doAsGroupId=" + themeDisplay.getScopeGroupId() + "&controlPanelCategory=current_site.pages&p_p_id=" + pagesPortlet.getPortletId();
                html = html.replace("{{pagesLink}}", "<li><a href=\"" + pagesUrl + "\">&gt; Pages</a></li>");
                Portlet usersPortlet = PortletLocalServiceUtil.getPortletById((long)themeDisplay.getCompanyId(), (String)"com_liferay_users_admin_web_portlet_UsersAdminPortlet");
                String usersUrl = themeDisplay.getPortalURL() + "/group/control_panel?refererPlid=" + themeDisplay.getPlid() + "&doAsGroupId=" + themeDisplay.getScopeGroupId() + "&controlPanelCategory=current_site.users&p_p_id=" + usersPortlet.getPortletId();
                html = html.replace("{{usersLink}}", "<li><a href=\"" + usersUrl + "\">&gt; Users</a></li>");
                Portlet contentPortlet = PortletLocalServiceUtil.getPortletById((long)themeDisplay.getCompanyId(), (String)"com_liferay_journal_web_portlet_JournalPortlet");
                String contentUrl = themeDisplay.getPortalURL() + "/group/control_panel?refererPlid=" + themeDisplay.getPlid() + "&doAsGroupId=" + themeDisplay.getScopeGroupId() + "&controlPanelCategory=current_site.content&p_p_id=" + contentPortlet.getPortletId();
                html = html.replace("{{contentLink}}", "<li><a href=\"" + contentUrl + "\">&gt; Content</a></li>");
                html = html.replace("{{controlPanelLink}}", "<li><a href=\"" + themeDisplay.getURLControlPanel() + "\">&gt; Control Panel</a></li>");
                Portlet configPortlet = PortletLocalServiceUtil.getPortletById((long)themeDisplay.getCompanyId(), (String)"com_liferay_configuration_web_portlet_SystemSettingsPortlet");
                String configUrl = themeDisplay.getPortalURL() + "/group/control_panel?refererPlid=" + themeDisplay.getPlid() + "&doAsGroupId=" + themeDisplay.getScopeGroupId() + "&controlPanelCategory=current_site.configuration&p_p_id=" + configPortlet.getPortletId();
                html = html.replace("{{configurations}}", "<li><a href=\"" + configUrl + "\">&gt; Configurations</a></li>");
                response.getWriter().println(html);
            }
        }
        return true;
    }

    public boolean includeIcon(HttpServletRequest request, HttpServletResponse response) {
        return false;
    }

    public boolean isPanelStateOpen(HttpServletRequest request, String key) {
        return false;
    }

    public boolean isShow(HttpServletRequest request) throws PortalException {
        return true;
    }

    public boolean isUseDialog() {
        return false;
    }

    public void setPanelState(HttpServletRequest request, String key, String panelState) {
    }

    public Map<String, Object> getData(HttpServletRequest request) {
        return Map.of("qa-id", "admin_links");
    }

    public String getIcon(HttpServletRequest request) {
        return "user-plus";
    }

    public String getIconCssClass(HttpServletRequest request) {
        return "";
    }

    public String getKey() {
        return "admin-links";
    }
}

