/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import javax.measure.quantity.Length;
import javax.measure.unit.Unit;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.styling.AbstractSymbolizer;
import org.geotools.styling.Description;
import org.geotools.styling.FillImpl;
import org.geotools.styling.Font;
import org.geotools.styling.FontImpl;
import org.geotools.styling.Graphic;
import org.geotools.styling.HaloImpl;
import org.geotools.styling.LabelPlacement;
import org.geotools.styling.LinePlacement;
import org.geotools.styling.LinePlacementImpl;
import org.geotools.styling.OtherText;
import org.geotools.styling.PointPlacementImpl;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.TextSymbolizer2;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.style.Fill;
import org.opengis.style.Halo;
import org.opengis.style.Symbolizer;
import org.opengis.style.TextSymbolizer;
import org.opengis.util.Cloneable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextSymbolizerImpl
extends AbstractSymbolizer
implements TextSymbolizer2,
Cloneable {
    private Font font;
    private final FilterFactory filterFactory;
    private FillImpl fill;
    private HaloImpl halo;
    private LabelPlacement placement;
    private Expression label = null;
    private Graphic graphic = null;
    private Expression priority = null;
    private Expression abxtract = null;
    private Expression description = null;
    private OtherText otherText = null;

    protected TextSymbolizerImpl() {
        this(CommonFactoryFinder.getFilterFactory(GeoTools.getDefaultHints()));
    }

    protected TextSymbolizerImpl(FilterFactory factory) {
        this(factory, null, null, null);
    }

    protected TextSymbolizerImpl(FilterFactory factory, Description desc, String name, Unit<Length> uom) {
        super(name, desc, (Expression)null, uom);
        this.filterFactory = factory;
        this.fill = new FillImpl(factory);
        this.fill.setColor((Expression)this.filterFactory.literal((Object)"#000000"));
        this.halo = null;
        this.placement = new PointPlacementImpl();
    }

    @Override
    public FillImpl getFill() {
        return this.fill;
    }

    @Override
    public void setFill(Fill fill) {
        if (this.fill == fill) {
            return;
        }
        this.fill = FillImpl.cast(fill);
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    @Override
    public void setFont(org.opengis.style.Font font) {
        if (this.font == font) {
            return;
        }
        this.font = FontImpl.cast(font);
    }

    @Override
    @Deprecated
    public Font[] getFonts() {
        if (this.font == null) {
            return new Font[0];
        }
        return new Font[]{this.font};
    }

    @Deprecated
    public void addFont(Font font) {
        this.font = font;
    }

    @Override
    @Deprecated
    public void setFonts(Font[] fonts) {
        this.font = fonts != null && fonts.length > 0 ? fonts[0] : null;
    }

    @Override
    public HaloImpl getHalo() {
        return this.halo;
    }

    @Override
    public void setHalo(Halo halo) {
        if (this.halo == halo) {
            return;
        }
        this.halo = HaloImpl.cast(halo);
    }

    @Override
    public Expression getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(Expression label) {
        this.label = label;
    }

    @Override
    @Deprecated
    public LabelPlacement getPlacement() {
        return this.getLabelPlacement();
    }

    @Override
    public void setPlacement(LabelPlacement labelPlacement) {
        this.setLabelPlacement(labelPlacement);
    }

    @Override
    public LabelPlacement getLabelPlacement() {
        return this.placement;
    }

    @Override
    public void setLabelPlacement(org.opengis.style.LabelPlacement labelPlacement) {
        if (this.placement == labelPlacement) {
            return;
        }
        this.placement = labelPlacement instanceof LinePlacement ? LinePlacementImpl.cast(labelPlacement) : PointPlacementImpl.cast(labelPlacement);
    }

    public Object accept(org.opengis.style.StyleVisitor visitor, Object data) {
        return visitor.visit((TextSymbolizer)this, data);
    }

    @Override
    public void accept(StyleVisitor visitor) {
        visitor.visit(this);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void setPriority(Expression priority) {
        if (this.priority == priority) {
            return;
        }
        this.priority = priority;
    }

    @Override
    public Expression getPriority() {
        return this.priority;
    }

    @Override
    public void addToOptions(String key, String value) {
        this.getOptions().put(key, value.trim());
    }

    @Override
    public String getOption(String key) {
        if (this.options == null) {
            return null;
        }
        return (String)this.options.get(key);
    }

    @Override
    public Graphic getGraphic() {
        return this.graphic;
    }

    @Override
    public void setGraphic(Graphic graphic) {
        if (this.graphic == graphic) {
            return;
        }
        this.graphic = graphic;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("<TextSymbolizerImp property=");
        buf.append(this.getGeometryPropertyName());
        buf.append(" label=");
        buf.append(this.label);
        buf.append(">");
        buf.append(this.font);
        return buf.toString();
    }

    @Override
    public Expression getSnippet() {
        return this.abxtract;
    }

    @Override
    public void setSnippet(Expression abxtract) {
        this.abxtract = abxtract;
    }

    @Override
    public Expression getFeatureDescription() {
        return this.description;
    }

    @Override
    public void setFeatureDescription(Expression description) {
        this.description = description;
    }

    @Override
    public OtherText getOtherText() {
        return this.otherText;
    }

    @Override
    public void setOtherText(OtherText otherText) {
        this.otherText = otherText;
    }

    static TextSymbolizerImpl cast(Symbolizer symbolizer) {
        if (symbolizer == null) {
            return null;
        }
        if (symbolizer instanceof TextSymbolizerImpl) {
            return (TextSymbolizerImpl)symbolizer;
        }
        TextSymbolizer textSymbolizer = (TextSymbolizer)symbolizer;
        TextSymbolizerImpl copy = new TextSymbolizerImpl();
        copy.setDescription(textSymbolizer.getDescription());
        copy.setFill(textSymbolizer.getFill());
        copy.setFont(textSymbolizer.getFont());
        copy.setGeometryPropertyName(textSymbolizer.getGeometryPropertyName());
        copy.setHalo(textSymbolizer.getHalo());
        copy.setLabel(textSymbolizer.getLabel());
        copy.setLabelPlacement(textSymbolizer.getLabelPlacement());
        copy.setName(textSymbolizer.getName());
        copy.setUnitOfMeasure((Unit<Length>)textSymbolizer.getUnitOfMeasure());
        return copy;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.abxtract == null ? 0 : this.abxtract.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.fill == null ? 0 : this.fill.hashCode());
        result = 31 * result + (this.filterFactory == null ? 0 : this.filterFactory.hashCode());
        result = 31 * result + (this.font == null ? 0 : this.font.hashCode());
        result = 31 * result + (this.graphic == null ? 0 : this.graphic.hashCode());
        result = 31 * result + (this.halo == null ? 0 : this.halo.hashCode());
        result = 31 * result + (this.label == null ? 0 : this.label.hashCode());
        result = 31 * result + (this.otherText == null ? 0 : this.otherText.hashCode());
        result = 31 * result + (this.placement == null ? 0 : this.placement.hashCode());
        result = 31 * result + (this.priority == null ? 0 : this.priority.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TextSymbolizerImpl other = (TextSymbolizerImpl)obj;
        if (this.abxtract == null ? other.abxtract != null : !this.abxtract.equals(other.abxtract)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.fill == null ? other.fill != null : !this.fill.equals(other.fill)) {
            return false;
        }
        if (this.filterFactory == null ? other.filterFactory != null : !this.filterFactory.equals(other.filterFactory)) {
            return false;
        }
        if (this.font == null ? other.font != null : !this.font.equals(other.font)) {
            return false;
        }
        if (this.graphic == null ? other.graphic != null : !this.graphic.equals(other.graphic)) {
            return false;
        }
        if (this.halo == null ? other.halo != null : !this.halo.equals(other.halo)) {
            return false;
        }
        if (this.label == null ? other.label != null : !this.label.equals(other.label)) {
            return false;
        }
        if (this.otherText == null ? other.otherText != null : !this.otherText.equals(other.otherText)) {
            return false;
        }
        if (this.placement == null ? other.placement != null : !this.placement.equals(other.placement)) {
            return false;
        }
        return !(this.priority == null ? other.priority != null : !this.priority.equals(other.priority));
    }
}

