/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.resources;

import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import org.geotools.resources.NIOUtilities;
import org.geotools.util.WeakCollectionCleaner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BufferSoftReference
extends SoftReference<ByteBuffer> {
    public BufferSoftReference(ByteBuffer referent) {
        super(referent, WeakCollectionCleaner.DEFAULT.getReferenceQueue());
    }

    @Override
    public void clear() {
        ByteBuffer buffer = (ByteBuffer)this.get();
        NIOUtilities.clean(buffer);
        super.clear();
    }

    public boolean equals(Object other) {
        if (!(other instanceof BufferSoftReference)) {
            return false;
        }
        ByteBuffer buffer = (ByteBuffer)this.get();
        if (buffer == null) {
            return false;
        }
        ByteBuffer otherBuffer = (ByteBuffer)((BufferSoftReference)other).get();
        if (otherBuffer == null) {
            return false;
        }
        return otherBuffer == buffer;
    }
}

