/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.io;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.n52.wps.ParserDocument;
import org.n52.wps.PropertyDocument;
import org.n52.wps.commons.WPSConfig;
import org.n52.wps.io.IParser;
import org.n52.wps.io.datahandler.parser.SimpleGMLParser;

public class ParserFactory {
    public static String PROPERTY_NAME_REGISTERED_PARSERS = "registeredParsers";
    private static ParserFactory factory;
    private static Logger LOGGER;
    private List<IParser> registeredParsers;

    public static void initialize(ParserDocument.Parser[] parsers) {
        if (factory == null) {
            factory = new ParserFactory(parsers);
        } else {
            LOGGER.warn((Object)"Factory already initialized");
        }
    }

    private ParserFactory(ParserDocument.Parser[] parsers) {
        this.loadAllParsers(parsers);
        WPSConfig.getInstance().addPropertyChangeListener("WPSConfigUpdate", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                LOGGER.info((Object)(this.getClass().getName() + ": Received Property Change Event: " + propertyChangeEvent.getPropertyName()));
                ParserFactory.this.loadAllParsers(WPSConfig.getInstance().getActiveRegisteredParser());
            }
        });
    }

    private void loadAllParsers(ParserDocument.Parser[] parsers) {
        this.registeredParsers = new ArrayList<IParser>();
        for (ParserDocument.Parser currentParser : parsers) {
            PropertyDocument.Property[] activeProperties = new PropertyDocument.Property[]{};
            ArrayList<PropertyDocument.Property> activePars = new ArrayList<PropertyDocument.Property>();
            for (int i = 0; i < currentParser.getPropertyArray().length; ++i) {
                if (!currentParser.getPropertyArray()[i].getActive()) continue;
                activePars.add(currentParser.getPropertyArray()[i]);
            }
            currentParser.setPropertyArray(activePars.toArray(activeProperties));
            String parserClass = currentParser.getClassName();
            IParser parser = null;
            try {
                parser = (IParser)this.getClass().getClassLoader().loadClass(parserClass).newInstance();
            }
            catch (ClassNotFoundException e) {
                LOGGER.error((Object)("One of the parsers could not be loaded: " + parserClass), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                LOGGER.error((Object)("One of the parsers could not be loaded: " + parserClass), (Throwable)e);
            }
            catch (InstantiationException e) {
                LOGGER.error((Object)("One of the parsers could not be loaded: " + parserClass), (Throwable)e);
            }
            if (parser == null) continue;
            LOGGER.info((Object)("Parser class registered: " + parserClass));
            this.registeredParsers.add(parser);
        }
    }

    public static ParserFactory getInstance() {
        if (factory == null) {
            ParserDocument.Parser[] parsers = WPSConfig.getInstance().getActiveRegisteredParser();
            ParserFactory.initialize(parsers);
        }
        return factory;
    }

    public IParser getParser(String schema, String format, String encoding, Class requiredInputClass) {
        if (encoding == null) {
            encoding = "UTF-8";
        }
        for (IParser parser : this.registeredParsers) {
            Class<?>[] supportedClasses;
            for (Class<?> clazz : supportedClasses = parser.getSupportedDataBindings()) {
                if (!clazz.equals(requiredInputClass) || !parser.isSupportedSchema(schema) || !parser.isSupportedEncoding(encoding) || !parser.isSupportedFormat(format)) continue;
                LOGGER.info((Object)("Matching parser found: " + parser));
                return parser;
            }
        }
        return null;
    }

    public IParser getSimpleParser() {
        return new SimpleGMLParser();
    }

    public List<IParser> getAllParsers() {
        return this.registeredParsers;
    }

    static {
        LOGGER = Logger.getLogger(ParserFactory.class);
    }
}

