/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.io.datahandler.generator;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.UUID;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.httpclient.HttpException;
import org.n52.wps.PropertyDocument;
import org.n52.wps.commons.WPSConfig;
import org.n52.wps.io.IOUtils;
import org.n52.wps.io.data.GenericFileData;
import org.n52.wps.io.data.IComplexData;
import org.n52.wps.io.data.IData;
import org.n52.wps.io.data.binding.complex.GTRasterDataBinding;
import org.n52.wps.io.data.binding.complex.GTVectorDataBinding;
import org.n52.wps.io.data.binding.complex.GeotiffBinding;
import org.n52.wps.io.data.binding.complex.ShapefileBinding;
import org.n52.wps.io.datahandler.generator.AbstractGenerator;
import org.n52.wps.io.datahandler.generator.GeoServerUploader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GeoserverWMSGenerator
extends AbstractGenerator {
    private String username;
    private String password;
    private String host;
    private String port;

    public GeoserverWMSGenerator() {
        this.supportedIDataTypes.add(GTRasterDataBinding.class);
        this.supportedIDataTypes.add(ShapefileBinding.class);
        this.supportedIDataTypes.add(GeotiffBinding.class);
        this.supportedIDataTypes.add(GTVectorDataBinding.class);
        for (PropertyDocument.Property property : this.properties = WPSConfig.getInstance().getPropertiesForGeneratorClass(this.getClass().getName())) {
            if (property.getName().equalsIgnoreCase("Geoserver_username")) {
                this.username = property.getStringValue();
            }
            if (property.getName().equalsIgnoreCase("Geoserver_password")) {
                this.password = property.getStringValue();
            }
            if (property.getName().equalsIgnoreCase("Geoserver_host")) {
                this.host = property.getStringValue();
            }
            if (!property.getName().equalsIgnoreCase("Geoserver_port")) continue;
            this.port = property.getStringValue();
        }
        if (this.port == null) {
            this.port = WPSConfig.getInstance().getWPSConfig().getServer().getHostport();
        }
        for (String supportedFormat : this.supportedFormats) {
            if (!supportedFormat.equals("text/xml")) continue;
            this.supportedFormats.remove(supportedFormat);
        }
    }

    @Override
    public InputStream generateStream(IData data, String mimeType, String schema) throws IOException {
        ByteArrayInputStream stream = null;
        try {
            Document doc = this.storeLayer(data);
            DOMSource domSource = new DOMSource(doc);
            StringWriter sw = new StringWriter();
            StreamResult result = new StreamResult(sw);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.transform(domSource, result);
            sw.flush();
            sw.close();
            stream = new ByteArrayInputStream(sw.toString().getBytes("UTF-8"));
        }
        catch (TransformerException ex) {
            ex.printStackTrace();
            throw new RuntimeException("Error generating WCS output. Reason: " + ex);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Error generating WCS output. Reason: " + e);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            throw new RuntimeException("Error generating WCS output. Reason: " + e);
        }
        return stream;
    }

    private Document storeLayer(IData coll) throws HttpException, IOException, ParserConfigurationException {
        IComplexData data;
        String path;
        GenericFileData fileData;
        IComplexData gtData;
        File file = null;
        String storeName = "";
        String wmsLayerName = "";
        if (coll instanceof GTVectorDataBinding) {
            File zipped;
            gtData = (GTVectorDataBinding)coll;
            try {
                fileData = new GenericFileData(((GTVectorDataBinding)gtData).getPayload());
                file = fileData.getBaseFile(true);
            }
            catch (IOException e1) {
                e1.printStackTrace();
                throw new RuntimeException("Error generating shp file for storage in WFS. Reason: " + e1);
            }
            path = file.getAbsolutePath();
            String baseName = path.substring(0, path.length() - ".shp".length());
            File shx = new File(baseName + ".shx");
            File dbf = new File(baseName + ".dbf");
            File prj = new File(baseName + ".prj");
            file = zipped = IOUtils.zip(file, shx, dbf, prj);
            wmsLayerName = new File(path).getName().substring(0, new File(path).getName().length() - 4);
        }
        if (coll instanceof GTRasterDataBinding) {
            gtData = (GTRasterDataBinding)coll;
            fileData = new GenericFileData(((GTRasterDataBinding)gtData).getPayload(), null);
            file = fileData.getBaseFile(true);
            int lastIndex = file.getName().lastIndexOf(".");
            wmsLayerName = file.getName().substring(0, lastIndex);
        }
        if (coll instanceof ShapefileBinding) {
            data = (ShapefileBinding)coll;
            file = ((ShapefileBinding)data).getZippedPayload();
            path = file.getAbsolutePath();
            wmsLayerName = new File(path).getName().substring(0, new File(path).getName().length() - 4);
        }
        if (coll instanceof GeotiffBinding) {
            data = (GeotiffBinding)coll;
            file = ((GeotiffBinding)data).getPayload();
            path = file.getAbsolutePath();
            wmsLayerName = new File(path).getName().substring(0, new File(path).getName().length() - 4);
        }
        storeName = file.getName();
        storeName = storeName + "_" + UUID.randomUUID();
        GeoServerUploader geoserverUploader = new GeoServerUploader(this.username, this.password, this.host, this.port);
        String result = geoserverUploader.createWorkspace();
        System.out.println(result);
        System.out.println("");
        if (coll instanceof GTVectorDataBinding) {
            result = geoserverUploader.uploadShp(file, storeName);
        }
        if (coll instanceof GTRasterDataBinding) {
            result = geoserverUploader.uploadGeotiff(file, storeName);
        }
        System.out.println(result);
        String capabilitiesLink = "http://" + this.host + ":" + this.port + "/geoserver/wms?Service=WMS&Request=GetCapabilities&Version=1.1.1";
        Document doc = this.createXML("N52:" + storeName, capabilitiesLink);
        return doc;
    }

    private Document createXML(String layerName, String getCapabilitiesLink) throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Document doc = factory.newDocumentBuilder().newDocument();
        Element root = doc.createElement("OWSResponse");
        root.setAttribute("type", "WMS");
        Element resourceIDElement = doc.createElement("ResourceID");
        resourceIDElement.appendChild(doc.createTextNode(layerName));
        root.appendChild(resourceIDElement);
        Element getCapabilitiesLinkElement = doc.createElement("GetCapabilitiesLink");
        getCapabilitiesLinkElement.appendChild(doc.createTextNode(getCapabilitiesLink));
        root.appendChild(getCapabilitiesLinkElement);
        doc.appendChild(root);
        return doc;
    }
}

