/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.io.datahandler.parser;

import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class GML2Handler
extends DefaultHandler {
    private Logger LOGGER = Logger.getLogger(GML2Handler.class);
    private String schemaUrl;
    private String nameSpaceURI;
    private boolean rootVisited = false;
    private Map<String, String> namespaces = new HashMap<String, String>();

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        String[] locationStrings;
        super.startElement(uri, localName, qName, attributes);
        if (this.rootVisited) {
            return;
        }
        if (localName.equals("xml-fragment")) {
            return;
        }
        this.rootVisited = true;
        String schemaLocationAttr = attributes.getValue("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation");
        if (schemaLocationAttr == null) {
            this.LOGGER.debug((Object)"schemaLocation attribute is not set correctly with namespace");
            schemaLocationAttr = attributes.getValue("xsi:schemaLocation");
            if (schemaLocationAttr == null) {
                schemaLocationAttr = attributes.getValue("schemaLocation");
            }
        }
        if ((locationStrings = schemaLocationAttr.replace("  ", " ").split(" ")).length % 2 != 0) {
            this.LOGGER.debug((Object)"schemaLocation does not reference locations correctly, odd number of whitespace separated addresses");
            return;
        }
        for (int i = 0; i < locationStrings.length; ++i) {
            if (i % 2 != 0 || locationStrings[i].equals("http://www.opengis.net/wfs") || locationStrings[i].equals("http://www.opengis.net/gml") || locationStrings[i].equals("")) continue;
            this.nameSpaceURI = locationStrings[i];
            this.schemaUrl = locationStrings[i + 1];
            return;
        }
    }

    public String getSchemaUrl() {
        return this.schemaUrl;
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        super.startPrefixMapping(prefix, uri);
        this.namespaces.put(prefix, uri);
    }

    public String getNameSpaceURI() {
        return this.nameSpaceURI;
    }
}

