/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.io.datahandler.parser;

import com.vividsolutions.jts.geom.Geometry;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.UUID;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.DefaultFeatureCollections;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.GeometryAttributeImpl;
import org.geotools.feature.type.GeometryDescriptorImpl;
import org.geotools.feature.type.GeometryTypeImpl;
import org.geotools.filter.identity.GmlObjectIdImpl;
import org.geotools.gml3.ApplicationSchemaConfiguration;
import org.geotools.gml3.GMLConfiguration;
import org.geotools.xml.Configuration;
import org.geotools.xml.Parser;
import org.n52.wps.io.SchemaRepository;
import org.n52.wps.io.data.GenericFileData;
import org.n52.wps.io.data.binding.complex.GenericFileDataBinding;
import org.n52.wps.io.datahandler.parser.AbstractParser;
import org.n52.wps.io.datahandler.parser.GML2Handler;
import org.opengis.feature.Feature;
import org.opengis.feature.GeometryAttribute;
import org.opengis.feature.Property;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.GeometryType;
import org.opengis.filter.identity.Identifier;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class GML3BasicParser4Files
extends AbstractParser {
    private static Logger LOGGER = Logger.getLogger(GML3BasicParser4Files.class);

    public GML3BasicParser4Files() {
        this.supportedIDataTypes.add(GenericFileDataBinding.class);
    }

    @Override
    public GenericFileDataBinding parse(InputStream stream, String mimeType, String schema) {
        FileOutputStream fos = null;
        try {
            File tempFile = File.createTempFile(UUID.randomUUID().toString(), ".gml3");
            this.finalizeFiles.add(tempFile);
            fos = new FileOutputStream(tempFile);
            int i = stream.read();
            while (i != -1) {
                fos.write(i);
                i = stream.read();
            }
            fos.flush();
            fos.close();
            GenericFileDataBinding data = this.parseXML(tempFile);
            return data;
        }
        catch (IOException e) {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception e1) {
                    // empty catch block
                }
            }
            throw new IllegalArgumentException("Error while creating tempFile", e);
        }
    }

    private GenericFileDataBinding parseXML(File file) {
        QName schematypeTuple = this.determineFeatureTypeSchema(file);
        if (schematypeTuple == null) {
            throw new NullPointerException("featureTypeSchema null for file: " + file.getPath());
        }
        String schemaLocation = schematypeTuple.getLocalPart();
        GMLConfiguration configuration = null;
        if (schemaLocation != null && schematypeTuple.getNamespaceURI() != null) {
            SchemaRepository.registerSchemaLocation(schematypeTuple.getNamespaceURI(), schemaLocation);
            configuration = new ApplicationSchemaConfiguration(schematypeTuple.getNamespaceURI(), schemaLocation);
        } else {
            configuration = new GMLConfiguration();
            configuration.getProperties().add(Parser.Properties.IGNORE_SCHEMA_LOCATION);
            configuration.getProperties().add(Parser.Properties.PARSE_UNKNOWN_ELEMENTS);
        }
        Parser parser = new Parser((Configuration)configuration);
        SimpleFeatureCollection fc = DefaultFeatureCollections.newCollection();
        try {
            Object parsedData = parser.parse((InputStream)new FileInputStream(file));
            if (parsedData instanceof FeatureCollection) {
                fc = (FeatureCollection)parsedData;
            } else {
                ArrayList featureList = (ArrayList)((HashMap)parsedData).get("featureMember");
                if (featureList != null) {
                    for (SimpleFeature feature : featureList) {
                        fc.add((Feature)feature);
                    }
                } else {
                    fc = (FeatureCollection)((HashMap)parsedData).get("FeatureCollection");
                }
            }
            for (SimpleFeature feature : fc) {
                if (feature.getDefaultGeometry() != null) continue;
                Collection properties = feature.getProperties();
                for (Property property : properties) {
                    try {
                        Geometry g = (Geometry)property.getValue();
                        if (g == null) continue;
                        GeometryAttribute oldGeometryDescriptor = feature.getDefaultGeometryProperty();
                        GeometryTypeImpl type = new GeometryTypeImpl(property.getName(), oldGeometryDescriptor.getType().getBinding(), oldGeometryDescriptor.getType().getCoordinateReferenceSystem(), oldGeometryDescriptor.getType().isIdentified(), oldGeometryDescriptor.getType().isAbstract(), oldGeometryDescriptor.getType().getRestrictions(), oldGeometryDescriptor.getType().getSuper(), oldGeometryDescriptor.getType().getDescription());
                        GeometryDescriptorImpl newGeometryDescriptor = new GeometryDescriptorImpl((GeometryType)type, property.getName(), 0, 1, true, null);
                        GmlObjectIdImpl identifier = new GmlObjectIdImpl(feature.getID());
                        GeometryAttributeImpl geo = new GeometryAttributeImpl((Object)g, (GeometryDescriptor)newGeometryDescriptor, (Identifier)identifier);
                        feature.setDefaultGeometryProperty((GeometryAttribute)geo);
                        feature.setDefaultGeometry((Object)g);
                    }
                    catch (ClassCastException e) {}
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        GenericFileDataBinding data = null;
        try {
            data = new GenericFileDataBinding(new GenericFileData((FeatureCollection<?, ?>)fc));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return data;
    }

    private QName determineFeatureTypeSchema(File file) {
        try {
            GML2Handler handler = new GML2Handler();
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.newSAXParser().parse((InputStream)new FileInputStream(file), (DefaultHandler)handler);
            String schemaUrl = handler.getSchemaUrl();
            String namespaceURI = handler.getNameSpaceURI();
            return new QName(namespaceURI, schemaUrl);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        catch (SAXException e) {
            throw new IllegalArgumentException(e);
        }
        catch (ParserConfigurationException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

