/*
 * Decompiled with CFR 0.152.
 */
package org.grade.common;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GradeUtils {
    private static final Logger log = LoggerFactory.getLogger(GradeUtils.class);
    private static final String EMAIL_PATTERN = "^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$";
    private static final Pattern pattern = Pattern.compile("^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$");
    static JsonNodeFactory factory = JsonNodeFactory.instance;
    static ObjectMapper mapper = new ObjectMapper();

    public static void verify(String msg, boolean expression) {
        if (!expression) {
            throw new IllegalArgumentException(msg);
        }
    }

    public static void notNull(String name, Object o) throws IllegalArgumentException {
        GradeUtils.verify(name + " is null", o != null);
    }

    public static void notEmpty(String name, String s) throws IllegalArgumentException {
        GradeUtils.notNull(name, s);
        GradeUtils.verify(name + " is empty", !s.isEmpty());
    }

    public static void validUri(String msg, String uri) throws IllegalArgumentException {
        try {
            URI o = URI.create(uri);
            if (!o.isAbsolute()) {
                throw new Exception("not an absolute URI");
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(msg, e);
        }
    }

    public static void validUris(String name, Collection<String> uris) throws IllegalArgumentException {
        GradeUtils.notNull(name, uris);
        for (String uri : uris) {
            GradeUtils.validUri(name, uri);
        }
    }

    public static void valid(String name, String s) throws IllegalArgumentException {
        GradeUtils.notNull(name, s);
        GradeUtils.notEmpty(name, s);
    }

    public static void positive(String name, int val) throws IllegalArgumentException {
        GradeUtils.verify(name + " is not positive", val > 0);
    }

    public static void notEmpty(String name, Collection<? extends Object> c) throws IllegalArgumentException {
        GradeUtils.notNull(name, c);
        GradeUtils.verify(name + " is empty", !c.isEmpty());
    }

    public static void notEmpty(String name, Object[] a) throws IllegalArgumentException {
        GradeUtils.notNull(name, a);
        GradeUtils.verify(name + " is empty", a.length > 0);
    }

    public static void valid(String name, Object[] a) throws IllegalArgumentException {
        GradeUtils.notNull(name, a);
        for (Object e : a) {
            GradeUtils.notNull(name + "'s element", e);
        }
    }

    public static void noNulls(String name, Collection<?> c) throws IllegalArgumentException {
        GradeUtils.notNull(name, c);
        GradeUtils.notEmpty(name, c);
        for (Object e : c) {
            GradeUtils.notNull(name + "'s element", e);
        }
    }

    public static void valid(String name, Collection<String> c) throws IllegalArgumentException {
        GradeUtils.notNull(name, c);
        GradeUtils.notEmpty(name, c);
        for (String e : c) {
            GradeUtils.valid(name + "'s element", e);
        }
    }

    public static void valid(File file) throws IllegalArgumentException {
        GradeUtils.notNull("file", file);
        GradeUtils.verify(file + " does not exist, is a directory, or cannot be read", file.exists() && !file.isDirectory() && file.canRead());
    }

    public static void validDirectory(File dir) throws IllegalArgumentException {
        GradeUtils.notNull("directory", dir);
        GradeUtils.verify(dir + " does not exist or cannot be read", dir.exists() && dir.canRead());
    }

    public static boolean isValid(File file) {
        GradeUtils.notNull("file", file);
        return file.exists() && !file.isDirectory() && file.canRead();
    }

    public static boolean isValidDirectory(File dir) {
        GradeUtils.notNull("directory", dir);
        return dir.exists() && dir.canRead();
    }

    public static void validEmail(String email) {
        GradeUtils.verify("invalid email address " + email, pattern.matcher(email).matches());
    }

    public static void valid(String text, QName name) throws IllegalArgumentException {
        GradeUtils.notNull(text, name);
        GradeUtils.valid(text, name.getLocalPart());
    }

    public static <T> T reveal(Object o, Class<T> type) {
        GradeUtils.notNull("object", o);
        try {
            return type.cast(o);
        }
        catch (ClassCastException e) {
            throw new AssertionError((Object)("expected a " + type + ", found instead a " + o.getClass()));
        }
    }

    public static RuntimeException unchecked(Throwable t) {
        return t instanceof RuntimeException ? (RuntimeException)RuntimeException.class.cast(t) : new RuntimeException(t);
    }

    public static RuntimeException unchecked(String msg, Throwable t) {
        msg = msg + " (see cause) ";
        return t instanceof IllegalArgumentException ? new IllegalArgumentException(msg, t) : (t instanceof IllegalStateException ? new IllegalStateException(msg, t) : new RuntimeException(msg, t));
    }

    public static void rethrowUnchecked(String msg, Throwable t) throws RuntimeException {
        throw GradeUtils.unchecked(msg, t);
    }

    public static void rethrowUnchecked(Throwable t) throws RuntimeException {
        throw GradeUtils.unchecked(t);
    }

    public static ObjectNode toJson(Object o) {
        return GradeUtils.toJson(o, false);
    }

    public static ObjectNode toJson(Object o, boolean print) {
        ObjectNode node = (ObjectNode)mapper.valueToTree(o);
        if (print) {
            try {
                System.out.println(mapper.writeValueAsString((Object)node));
            }
            catch (Exception e) {
                throw GradeUtils.unchecked(e);
            }
        }
        return node;
    }

    public static <T> T fromJson(JsonNode node, Class<T> type) {
        try {
            return (T)mapper.treeToValue((TreeNode)node, type);
        }
        catch (Exception e) {
            throw GradeUtils.unchecked("cannot parse json", e);
        }
    }

    public static <T> T jsonRoundtrip(T o) {
        return GradeUtils.jsonRoundtrip(o, false);
    }

    public static <T> T jsonRoundtrip(T o, boolean print) {
        return (T)GradeUtils.fromJson((JsonNode)GradeUtils.toJson(o, print), o.getClass());
    }

    public static void time(String msg, Consumer<Void> c) {
        long time = System.currentTimeMillis();
        c.accept(null);
        log.trace("{} ({} ms)", (Object)msg, (Object)(System.currentTimeMillis() - time));
    }

    public static void deleteDir(Path location) throws Exception {
        if (!Files.exists(location, new LinkOption[0])) {
            return;
        }
        if (!Files.isDirectory(location, new LinkOption[0])) {
            throw new IllegalArgumentException(location + " is not a directory");
        }
        Files.walkFileTree(location, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    static {
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
    }
}

