/*
 * Decompiled with CFR 0.152.
 */
package org.grade.configuration;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import lombok.NonNull;
import org.grade.common.GradeUtils;
import org.grade.configuration.GraphConfiguration;

public class EndpointConfiguration {
    @JsonProperty(value="id")
    @NonNull
    private String id = UUID.randomUUID().toString();
    @JsonProperty(value="name")
    @NonNull
    private String name;
    @JsonProperty(value="uri")
    @NonNull
    String uri;
    @JsonProperty(value="update uri")
    String writeUri;
    @JsonProperty(value="graph")
    Set<GraphConfiguration> graphs = new HashSet<GraphConfiguration>();
    @JsonProperty(value="status")
    Status status = Status.data;
    @JsonProperty(value="locked")
    boolean locked = false;

    public static EndpointConfiguration endpoint(String name, String readUri, GraphConfiguration ... graphs) {
        EndpointConfiguration config = new EndpointConfiguration(name, readUri);
        config.graphs.addAll(Arrays.asList(graphs));
        return config;
    }

    public static EndpointConfiguration endpoint(EndpointConfiguration endpoint) {
        EndpointConfiguration config = EndpointConfiguration.endpoint(endpoint.name(), endpoint.uri());
        config.status(endpoint.status());
        return config;
    }

    public EndpointConfiguration writeUri(String uri) {
        GradeUtils.validUri((String)"write uri", (String)uri);
        this.writeUri = uri;
        return this;
    }

    public boolean canAdd() {
        return this.writeUri != null && !this.writeUri.isEmpty();
    }

    public boolean canDelete() {
        return this.canAdd() && !this.locked;
    }

    public EndpointConfiguration uri(String uri) {
        GradeUtils.validUri((String)"read uri", (String)uri);
        this.uri = uri;
        return this;
    }

    @NonNull
    public String id() {
        return this.id;
    }

    @NonNull
    public String name() {
        return this.name;
    }

    @NonNull
    public String uri() {
        return this.uri;
    }

    public String writeUri() {
        return this.writeUri;
    }

    public Set<GraphConfiguration> graphs() {
        return this.graphs;
    }

    public Status status() {
        return this.status;
    }

    public boolean locked() {
        return this.locked;
    }

    public EndpointConfiguration id(@NonNull String id) {
        if (id == null) {
            throw new IllegalArgumentException("id is null");
        }
        this.id = id;
        return this;
    }

    public EndpointConfiguration name(@NonNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        this.name = name;
        return this;
    }

    public EndpointConfiguration graphs(Set<GraphConfiguration> graphs) {
        this.graphs = graphs;
        return this;
    }

    public EndpointConfiguration status(Status status) {
        this.status = status;
        return this;
    }

    public EndpointConfiguration locked(boolean locked) {
        this.locked = locked;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EndpointConfiguration)) {
            return false;
        }
        EndpointConfiguration other = (EndpointConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.id();
        String other$id = other.id();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.name();
        String other$name = other.name();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$uri = this.uri();
        String other$uri = other.uri();
        if (this$uri == null ? other$uri != null : !this$uri.equals(other$uri)) {
            return false;
        }
        String this$writeUri = this.writeUri();
        String other$writeUri = other.writeUri();
        if (this$writeUri == null ? other$writeUri != null : !this$writeUri.equals(other$writeUri)) {
            return false;
        }
        Set<GraphConfiguration> this$graphs = this.graphs();
        Set<GraphConfiguration> other$graphs = other.graphs();
        if (this$graphs == null ? other$graphs != null : !((Object)this$graphs).equals(other$graphs)) {
            return false;
        }
        Status this$status = this.status();
        Status other$status = other.status();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        return this.locked() == other.locked();
    }

    protected boolean canEqual(Object other) {
        return other instanceof EndpointConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.id();
        result = result * 59 + ($id == null ? 0 : $id.hashCode());
        String $name = this.name();
        result = result * 59 + ($name == null ? 0 : $name.hashCode());
        String $uri = this.uri();
        result = result * 59 + ($uri == null ? 0 : $uri.hashCode());
        String $writeUri = this.writeUri();
        result = result * 59 + ($writeUri == null ? 0 : $writeUri.hashCode());
        Set<GraphConfiguration> $graphs = this.graphs();
        result = result * 59 + ($graphs == null ? 0 : ((Object)$graphs).hashCode());
        Status $status = this.status();
        result = result * 59 + ($status == null ? 0 : ((Object)((Object)$status)).hashCode());
        result = result * 59 + (this.locked() ? 79 : 97);
        return result;
    }

    public EndpointConfiguration() {
    }

    private EndpointConfiguration(@NonNull String name, @NonNull String uri) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if (uri == null) {
            throw new IllegalArgumentException("uri is null");
        }
        this.name = name;
        this.uri = uri;
    }

    public static EndpointConfiguration endpoint(@NonNull String name, @NonNull String uri) {
        return new EndpointConfiguration(name, uri);
    }

    public String toString() {
        return "EndpointConfiguration(id=" + this.id() + ", name=" + this.name() + ", uri=" + this.uri() + ", writeUri=" + this.writeUri() + ", status=" + (Object)((Object)this.status()) + ", locked=" + this.locked() + ")";
    }

    public static enum Status {
        system,
        data;

    }
}

