/*
 * Decompiled with CFR 0.152.
 */
package org.grade.configuration.impl;

import java.io.File;
import javax.enterprise.context.ApplicationScoped;
import org.grade.common.GradeUtils;

@ApplicationScoped
public class ConfigurationLocator {
    public File locate() throws IllegalStateException {
        File dir = this.locate_directory();
        if (dir == null && !GradeUtils.isValid((File)new File(dir = new File(System.getProperty("user.dir")), "grade.json"))) {
            dir = new File(System.getProperty("user.home"));
        }
        return new File(dir, "grade.json");
    }

    private File locate_directory() {
        String location = System.getProperty("grade.config");
        if (location != null) {
            return this.validDirectory(location);
        }
        location = System.getenv("grade.config");
        if (location != null) {
            return this.validDirectory(location);
        }
        return null;
    }

    private File validDirectory(String location) {
        File file = new File(location);
        try {
            GradeUtils.validDirectory((File)file);
        }
        catch (Exception e) {
            throw GradeUtils.unchecked((String)("invalid configuration @ " + file), (Throwable)e);
        }
        return file;
    }
}

