/*
 * Decompiled with CFR 0.152.
 */
package org.grade.configuration;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.NonNull;
import org.grade.common.GradeUtils;

public class GraphConfiguration {
    @JsonProperty(value="uri")
    @NonNull
    String uri;
    @JsonProperty(value="label")
    String label;
    @JsonProperty(value="size")
    int size;

    public GraphConfiguration uri(String uri) {
        GradeUtils.validUri((String)"graph uri", (String)uri);
        this.uri = uri;
        return this;
    }

    @NonNull
    public String uri() {
        return this.uri;
    }

    public String label() {
        return this.label;
    }

    public int size() {
        return this.size;
    }

    public GraphConfiguration label(String label) {
        this.label = label;
        return this;
    }

    public GraphConfiguration size(int size) {
        this.size = size;
        return this;
    }

    public String toString() {
        return "GraphConfiguration(uri=" + this.uri() + ", label=" + this.label() + ", size=" + this.size() + ")";
    }

    public GraphConfiguration() {
    }

    private GraphConfiguration(@NonNull String uri) {
        if (uri == null) {
            throw new IllegalArgumentException("uri is null");
        }
        this.uri = uri;
    }

    public static GraphConfiguration graph(@NonNull String uri) {
        return new GraphConfiguration(uri);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GraphConfiguration)) {
            return false;
        }
        GraphConfiguration other = (GraphConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$uri = this.uri();
        String other$uri = other.uri();
        if (this$uri == null ? other$uri != null : !this$uri.equals(other$uri)) {
            return false;
        }
        String this$label = this.label();
        String other$label = other.label();
        if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
            return false;
        }
        return this.size() == other.size();
    }

    protected boolean canEqual(Object other) {
        return other instanceof GraphConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $uri = this.uri();
        result = result * 59 + ($uri == null ? 0 : $uri.hashCode());
        String $label = this.label();
        result = result * 59 + ($label == null ? 0 : $label.hashCode());
        result = result * 59 + this.size();
        return result;
    }
}

