/*
 * Decompiled with CFR 0.152.
 */
package org.grade.io.transforms;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import org.grade.io.transforms.RawTransform;
import org.grade.io.transforms.TransformUtils;

@ApplicationScoped
public class XmlTransform
implements RawTransform<Source> {
    @Inject
    private XMLInputFactory factory;

    @Override
    public Class<Source> type() {
        return Source.class;
    }

    @Override
    public Model triplify(Source xml) throws Exception {
        XMLStreamReader reader = this.factory.createXMLStreamReader(xml);
        Model model = ModelFactory.createDefaultModel();
        reader.nextTag();
        this.mapComplex(model, reader, null);
        return model;
    }

    /*
     * Enabled aggressive block sorting
     */
    private String mapComplex(Model model, XMLStreamReader reader, String parentUri) throws Exception {
        QName name = reader.getName();
        String uri = TransformUtils.mintA(name.getLocalPart());
        if (parentUri == null) {
            parentUri = uri;
        }
        boolean complex = false;
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            complex = true;
            TransformUtils.emitLiteral(model, uri, reader.getAttributeName(i).getLocalPart(), reader.getAttributeValue(i));
        }
        block6: while (reader.hasNext()) {
            int next = reader.next();
            switch (next) {
                case 1: {
                    QName childName = reader.getName();
                    String childURI = this.mapComplex(model, reader, uri);
                    if (childURI != null) {
                        TransformUtils.emit(model, uri, childName.getLocalPart(), childURI);
                    }
                    complex = true;
                    break;
                }
                case 4: {
                    if (reader.getText().trim().isEmpty()) break;
                    TransformUtils.emitLiteral(model, complex ? uri : parentUri, name.getLocalPart(), reader.getText());
                    break;
                }
                case 2: {
                    break block6;
                }
            }
        }
        if (!complex) return null;
        String string = uri;
        return string;
    }

    public String toString() {
        return "Xml -> Raw";
    }
}

