/*
 * Decompiled with CFR 0.152.
 */
package org.grade.io;

import com.hp.hpl.jena.rdf.model.Model;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.grade.common.GradeUtils;
import org.grade.io.transforms.RawTransform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class Transformer {
    private static final Logger log = LoggerFactory.getLogger(Transformer.class);
    List<RawTransform<?>> transforms = new ArrayList();

    @Inject
    public Transformer(Instance<RawTransform<?>> transforms) {
        transforms.forEach($ -> {
            log.info("registering {}", (Object)this.toString((RawTransform<?>)$));
            this.transforms.add((RawTransform<?>)$);
        });
    }

    public <T> Model transform(T source) throws IllegalStateException, RuntimeException {
        Optional<RawTransform> lookup = this.transforms.stream().filter($ -> $.type().isInstance(source)).findFirst();
        if (!lookup.isPresent()) {
            throw new IllegalStateException("no transform for " + source.getClass());
        }
        RawTransform transform = lookup.get();
        try {
            Model model = transform.triplify(source);
            log.trace("produced " + model.size() + " triples with transform " + transform);
            return model;
        }
        catch (Throwable t) {
            throw GradeUtils.unchecked((String)("cannot transform source with " + this.toString(transform)), (Throwable)t);
        }
    }

    private String toString(RawTransform<?> $) {
        return String.format("Transform %s (%s)", $.toString(), $.type());
    }

    public Transformer() {
    }
}

